% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-source-spct.R
\name{scale_y_s.e.irrad_continuous}
\alias{scale_y_s.e.irrad_continuous}
\alias{scale_y_s.q.irrad_continuous}
\alias{scale_y_s.e.irrad_log10}
\alias{scale_y_s.q.irrad_log10}
\title{Spectral irradiance y-scale}
\usage{
scale_y_s.e.irrad_continuous(
  unit.exponent = 0,
  name = s.e.irrad_label(unit.exponent = unit.exponent, markup.format = markup.format,
    time.unit = "second", label.text = label.text, pc.out = pc.out, scaled = scaled,
    normalized = normalized, axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = unit.exponent - pc.out * 2),
  markup.format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["s.e.irrad"]],
  pc.out = FALSE,
  scaled = FALSE,
  normalised = FALSE,
  normalized = normalised,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)

scale_y_s.q.irrad_continuous(
  unit.exponent = -6,
  name = s.q.irrad_label(unit.exponent = unit.exponent, markup.format = markup.format,
    time.unit = "second", label.text = label.text, pc.out = pc.out, scaled = scaled,
    normalized = normalized, axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = unit.exponent - pc.out * 2),
  markup.format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["s.q.irrad"]],
  pc.out = FALSE,
  scaled = FALSE,
  normalised = FALSE,
  normalized = normalised,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)

scale_y_s.e.irrad_log10(
  unit.exponent = 0,
  name = s.e.irrad_label(unit.exponent = unit.exponent, markup.format = markup.format,
    time.unit = "second", label.text = label.text, pc.out = pc.out, scaled = scaled,
    normalized = normalized, axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = unit.exponent - pc.out * 2),
  markup.format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["s.e.irrad"]],
  pc.out = FALSE,
  scaled = FALSE,
  normalised = FALSE,
  normalized = normalised,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)

scale_y_s.q.irrad_log10(
  unit.exponent = -6,
  name = s.q.irrad_label(unit.exponent = unit.exponent, markup.format = markup.format,
    time.unit = "second", label.text = label.text, pc.out = pc.out, scaled = scaled,
    normalized = normalized, axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = unit.exponent - pc.out * 2),
  markup.format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["s.q.irrad"]],
  pc.out = FALSE,
  scaled = FALSE,
  normalised = FALSE,
  normalized = normalised,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{markup.format}{character string, "R", "R.expression", "r.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{pc.out}{logical, if \code{TRUE} use percent instead of fraction of one
for normalized spectral data.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized, normalised}{logical (\code{FALSE}) or numeric Normalization
wavelength in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the default \code{name}.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw detector counts.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(sun.spct, unit.out = "energy") +
  geom_line() +
  scale_y_s.e.irrad_continuous() +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(unit.exponent = -3) +
  scale_x_wl_continuous()

ggplot(fscale(sun.spct)) +
  geom_line() +
  scale_y_s.e.irrad_continuous(scaled = TRUE) +
  scale_x_wl_continuous()

ggplot(normalize(sun.spct, norm = "max")) +
  geom_line() +
  scale_y_s.e.irrad_continuous(normalized = "max") +
  scale_x_wl_continuous()

my.spct <- normalize(q2e(sun.spct, action = "replace"), norm = "max")
ggplot(my.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(normalized = normalization(my.spct)$norm.type,
                               pc.out = TRUE) +
  scale_x_wl_continuous()

ggplot(my.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(normalized = normalization(my.spct)$norm.wl,
                               pc.out = TRUE) +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(axis.symbols = FALSE) +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(label.text = "") +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(label.text = "Irradiancia espectral,") +
  scale_x_wl_continuous(label.text = "Longitud de onda,")

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(unit.exponent = -1) +
  scale_x_wl_continuous()

ggplot(sun.spct, unit.out = "photon") +
  geom_line() +
  scale_y_s.q.irrad_continuous() +
  scale_x_wl_continuous()

ggplot(clip_wl(sun.spct, c(295, NA))) +
  geom_line() +
  scale_y_s.e.irrad_log10() +
  scale_x_wl_continuous()

ggplot(clip_wl(sun.spct, c(295, NA)),
  unit.out = "photon") +
  geom_line(na.rm = TRUE) +
  scale_y_s.q.irrad_log10() +
  scale_x_wl_continuous()

}
