% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{A_label}
\alias{A_label}
\alias{A_internal_label}
\alias{A_total_label}
\title{Absorbance axis labels}
\usage{
A_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  Tfr.type
)

A_internal_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

A_total_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{Tfr.type}{character, either "total" or "internal".}
}
\value{
a character string or an R expression.
}
\description{
Generate cps axis labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\note{
Default for \code{label.text} depends on the value passed as argument
  to \code{Tfr.type}.
}
\examples{

A_label(Tfr.type = "internal")
A_label(Tfr.type = "total")
A_label(Tfr.type = "total", axis.symbols = FALSE)


A_internal_label()
A_internal_label(format = "R.expression", axis.symbols = FALSE)
A_internal_label(-3)
A_internal_label(format = "R.expression")
A_internal_label(format = "LaTeX")
A_internal_label(-3, format = "LaTeX")


A_total_label()
A_total_label(format = "R.expression", axis.symbols = FALSE)
A_total_label(-3)
A_total_label(format = "R.expression")
A_total_label(format = "LaTeX")
A_total_label(-3, format = "LaTeX")

}
