% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_join.R
\name{brain_join}
\alias{brain_join}
\title{Join user data with a brain atlas}
\usage{
brain_join(data, atlas, by = NULL)
}
\arguments{
\item{data}{A data.frame with a column matching an atlas column
(typically `"region"`). Can be grouped with [dplyr::group_by()].}

\item{atlas}{A `ggseg_atlas` object or data.frame containing atlas data.}

\item{by}{Character vector of column names to join by. If `NULL` (default),
columns are detected automatically.}
}
\value{
An `sf` object if the atlas contains geometry, otherwise a tibble.
}
\description{
Performs a full join between user data and a brain atlas. Grouped data
is handled automatically, producing one complete atlas per group.
}
\examples{
someData <- data.frame(
  region = c(
    "transverse temporal", "insula",
    "precentral", "superior parietal"
  ),
  p = sample(seq(0, .5, .001), 4),
  stringsAsFactors = FALSE
)

brain_join(someData, dk())
brain_join(someData, dk(), "region")

}
