% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{ob_ngon}
\alias{ob_ngon}
\title{The ob_ngon (regular polygon) class}
\usage{
ob_ngon(
  center = ob_point(0, 0),
  n = 3L,
  radius = numeric(0),
  angle = 0,
  label = character(0),
  side_length = numeric(0),
  apothem = numeric(0),
  vertex_radius = numeric(0),
  alpha = numeric(0),
  color = character(0),
  fill = character(0),
  linewidth = numeric(0),
  linetype = numeric(0),
  style = S7::class_missing,
  x = numeric(0),
  y = numeric(0),
  id = character(0),
  ...
)
}
\arguments{
\item{center}{point at center of the ngon}

\item{n}{Number of sides}

\item{radius}{Distance from center to a vertex}

\item{angle}{description}

\item{label}{A character, angle, or label object}

\item{side_length}{Distance of each side}

\item{apothem}{Distance from center to a side's midpoint}

\item{vertex_radius}{A numeric or unit vector of length one, specifying the corner radius}

\item{alpha}{numeric value for alpha transparency}

\item{color}{character string for color}

\item{fill}{character string for fill color}

\item{linewidth}{Width of lines}

\item{linetype}{type of lines}

\item{style}{Gets and sets the styles associated with \code{\link{ob_ngon}}}

\item{x}{overrides x-coordinate in \code{center@x}}

\item{y}{overrides y-coordinate in \code{center@y}}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> properties passed to style}
}
\value{
\code{\link{ob_ngon}} object
}
\description{
An ngon is a regular polygon, meaning that each side is of equal length. The \code{\link{ob_ngon}} object can be specified with a center, n (number of sides), radius, and angle. Instead of specifying a radius, one can specify either the \code{side_length} or the length of the \code{apothem} (i.e., the distance from the center to a side's midpoint.
}
\section{Slots}{

\describe{
\item{\code{area}}{The area of the ngons in the \code{\link{ob_ngon}} object}

\item{\code{length}}{The number of ngons in the \code{\link{ob_ngon}} object}

\item{\code{normal_at}}{A function that finds a point that is perpendicular from the ngon and at a specified distance}

\item{\code{perimeter}}{The length of all the side segments}

\item{\code{point_at}}{A function that finds a point on the ngon at the specified angle.}

\item{\code{segments}}{side segments of the regular polygon}

\item{\code{tangent_at}}{A function that finds the tangent line at the specified angle.}

\item{\code{tibble}}{Gets a tibble (data.frame) containing parameters and styles used by \code{ggforce::geom_shape}.}

\item{\code{vertices}}{points on the regular polygon}
}}

