% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic-helper.R
\name{genomic_density}
\alias{genomic_density}
\title{Calculate Genomic Region Density}
\usage{
genomic_density(
  region,
  window_size = 1e+07,
  n_window = NULL,
  overlap = TRUE,
  mode = c("coverage", "count"),
  seqlengths = NULL
)
}
\arguments{
\item{region}{A data frame with at least 3 columns: chromosome, start, and
end.
\itemize{
\item Column 1: character or factor, chromosome name.
\item Column 2: numeric, start position (must be <= end).
\item Column 3: numeric, end position.
}}

\item{window_size}{Numeric, the width of each window (default is \code{1e+07}).
Ignored if \code{n_window} is specified.}

\item{n_window}{Integer, the number of windows per chromosome. If provided,
overrides \code{window_size} and evenly splits the chromosome into \code{n_window}
(non-overlapping) or \code{2*n_window - 1} (overlapping) windows.}

\item{overlap}{Logical, whether to use overlapping windows (default \code{TRUE}).
Overlapping windows are spaced by half the window size.}

\item{mode}{Character, either \code{"coverage"} or \code{"count"}:
\itemize{
\item \code{"count"}: reports the number of regions overlapping each window.
\item \code{"coverage"}: reports the fraction of each window covered by regions.
}}

\item{seqlengths}{Optional named vector of chromosome lengths. If missing,
the maximum \code{end} value in the input is used as the chromosome length.}
}
\value{
A data frame containing the first three columns from \code{region},
plus a fourth column \code{density}, which represents either the region count
or the coverage percentage, depending on \code{mode}.
}
\description{
Computes the density or count of genomic regions in sliding or fixed windows
across the genome. The density can be reported as the percentage of uncovered
bases or the number of overlapping regions within each window.
}
\details{
This function splits the input by chromosome and tiles the genomic space
into windows, optionally overlapping. For each window, it calculates:
\itemize{
\item the number of regions that overlap it (if \code{mode = "count"}), or
\item the fraction of bases covered by any region (if \code{mode = "percent"}).
}
}
\examples{
region <- data.frame(
    chr = rep("chr1", 3),
    start = c(100, 5000000, 15000000),
    end = c(2000000, 7000000, 17000000)
)
genomic_density(region, window_size = 1e7, mode = "count")
genomic_density(region, n_window = 3, overlap = FALSE, mode = "coverage")

}
