% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{get_geo_richness}
\alias{get_geo_richness}
\title{calculate the richness of a list of species over a given landscape}
\usage{
get_geo_richness(species_list, landscape)
}
\arguments{
\item{species_list}{a list of species to include in the richness calculations}

\item{landscape}{the landscape to calculate the richnness over}
}
\value{
a vector with the richness for every cell in the input landscape
}
\description{
calculate the richness of a list of species over a given landscape
}
\examples{
# get path containing example rasters
datapath <- system.file(file.path("extdata", "WorldCenter"), package="gen3sis")
# get species at t0
species_t_0 <- readRDS(file.path(datapath, 
                        "output/config_worldcenter/species/species_t_0.rds"))
# get landscape at t0
landscape_t_0 <- readRDS(file.path(datapath, 
                          "output/config_worldcenter/landscapes/landscape_t_0.rds"))
# get geo richness
richness_t_0 <- get_geo_richness(species_t_0, landscape_t_0)

# histogram of richness at t0
hist(richness_t_0)

## plot richness using raster and gen3sis color_richness (see plot_richness for alternative)
# combine richness and geographical coordinates
geo_richness_t_0 <- cbind(landscape_t_0$coordinates, richness_t_0)
library(raster)
plot(rasterFromXYZ(geo_richness_t_0), col=color_richness(20))
}
\seealso{
\code{\link{plot_richness}}
}
