% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuralnet.R
\name{neuralnet}
\alias{neuralnet}
\title{Neural Network by Multilayer Perceptron}
\usage{
neuralnet(
  object,
  formula,
  factor = 1,
  hidden = c(2),
  linear.output = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class \code{GEM}.}

\item{formula}{A formula specifying the model to be fitted. If not provided, the response variable is taken from the \code{GEM} object.}

\item{factor}{The factor to be used as response. If \code{formula} is provided, this is ignored.}

\item{hidden}{Vector with numbers of neurons in the hidden layers.}

\item{linear.output}{Logical. If \code{TRUE} the output layer is linear, otherwise it is logistic.}

\item{...}{Additional arguments passed to \code{neuralnet}.}
}
\value{
A \code{neuralnet} object that can be inspected and plotted.
}
\description{
Neural Network by Multilayer Perceptron
}
\examples{
data(candies, package = "HDANOVA")
gemC <- GEM(assessment ~ assessor*candy, data=candies)

# Neural network model
nn <- neuralnet(gemC, factor = "candy", hidden = c(2))
plot(nn, rep="best")

# Network weights (input and hidden layers)
nn$weights
}
\seealso{
Analyses using \code{GEM}: \code{\link{elastic}}, \code{\link{pca}}, \code{\link{sca}}, \code{\link{neuralnet}}, \code{\link{pls}}.
Confidence interval plots: \code{\link{confints}}. Convenience knock-in and knock-out of effects: \code{\link{knock.in}}.
}
