% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_get_disk_free_space}
\alias{vsi_get_disk_free_space}
\title{Return free disk space available on the filesystem}
\usage{
vsi_get_disk_free_space(path)
}
\arguments{
\item{path}{Character string. A directory of the filesystem to query.}
}
\value{
Numeric scalar. The free space in bytes (as \code{bit64::integer64}
type), or \code{-1} in case of error.
}
\description{
\code{vsi_get_disk_free_space()} returns the free disk space available on the
filesystem. Wrapper for \code{VSIGetDiskFreeSpace()} in the GDAL Common
Portability Library.
}
\examples{
tmp_dir <- file.path("/vsimem", "tmpdir")
vsi_mkdir(tmp_dir)
vsi_get_disk_free_space(tmp_dir)
vsi_rmdir(tmp_dir)
}
