% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnormratio.R
\name{dnormratio}
\alias{dnormratio}
\title{Density Function of a Normal Ratio Distribution}
\usage{
dnormratio(z, bet, rho, delta, r = 0)
}
\arguments{
\item{z}{length \eqn{p} numeric vector.}

\item{bet, rho, delta}{numeric values. The parameters \eqn{(\beta, \rho, \delta_y)} of the distribution, see Details.}

\item{r}{numeric. The correlation coefficient. Default \code{r=0} (the two distributions are considered independent).}
}
\value{
Numeric: the value of density.
}
\description{
Density of the ratio of two \if{html}{\out{<!-- independent -->}} Gaussian distributions.
}
\details{
Let two independent random variables
\eqn{X \sim N(\mu_x, \sigma_x)} and \eqn{Y \sim N(\mu_y, \sigma_y)}.\if{html}{\out{
<!-- with \eqn{\mu_x > 0} and \eqn{\mu_y > 0}. -->
}}


If we denote \eqn{\beta = \frac{\mu_x}{\mu_y}}, \eqn{\displaystyle{\rho = \frac{\sigma_y}{\sigma_x}}}
and \eqn{\displaystyle{\delta_y = \frac{\sigma_y}{\mu_y}}},
the probability distribution function of the ratio \eqn{\displaystyle{Z = \frac{X}{Y}}}
is given by:
\deqn{\displaystyle{ f_Z(z; \beta, \rho, \delta_y) = \frac{\rho}{\pi (1 + \rho^2 z^2)} \left[ \exp{\left(-\frac{\rho^2 \beta^2 + 1}{2\delta_y^2}\right)} + \sqrt{\frac{\pi}{2}} \ q \ \text{erf}\left(\frac{q}{\sqrt{2}}\right) \exp\left(-\frac{\rho^2 (z-\beta)^2}{2 \delta_y^2 (1 + \rho^2 z^2)}\right) \right] }}
with \eqn{\displaystyle{ q = \frac{1 + \beta \rho^2 z}{\delta_y \sqrt{1 + \rho^2 z^2}} }}
and \eqn{\displaystyle{ \text{erf}\left(\frac{q}{\sqrt{2}}\right) = \frac{2}{\sqrt{\pi}} \int_0^{\frac{q}{\sqrt{2}}}{\exp{(-t^2)}\ dt} }}

Another expression of this density, used by the \code{\link[=estparnormratio]{estparnormratio()}} function, is:
\deqn{\displaystyle{
f_Z(z; \beta, \rho, \delta_y) = \frac{\rho}{\pi (1 + \rho^2 z^2)} \ \exp{\left(-\frac{\rho^2 \beta^2 + 1}{2\delta_y^2}\right)} \ {}_1 F_1\left( 1, \frac{1}{2}; \frac{1}{2 \delta_y^2} \frac{(1 + \beta \rho^2 z)^2}{1 + \rho^2 z^2} \right)
}}

where \eqn{_1 F_1\left(a, b; x\right)} is the confluent hypergeometric function
(Kummer's function):
\deqn{\displaystyle{
_1 F_1\left(a, b; x\right) = \sum_{n = 0}^{+\infty}{ \frac{ (a)_n }{ (b)_n } \frac{x^n}{n!} }
}}

If \eqn{X} and \eqn{Y} are not independent,
let \eqn{r = Cor(X, Y) = \frac{Cov(X, Y)}{\sigma_X \sigma_Y}},
the probability distribution of \eqn{Z = \frac{X}{Y}} is:
\deqn{\displaystyle{
f_Z(z; \beta, \rho, \delta_y, r) = \frac{\rho \sqrt{1 - r^2}}{\pi (\rho^2 z^2 - 2r \rho z +1)} \ \exp{\left(-\frac{\rho^2 \beta^2 - 2r \beta \rho + 1}{2(1 - r^2) \delta_y^2}\right)} \ {}_1 F_1\left( 1, \frac{1}{2}; \frac{1}{2(1 - r^2) \delta_y^2} \frac{(\beta \rho^2 z - r\rho(z + \beta) + 1)^2}{\rho^2 z^2 - 2r \rho z + 1} \right)
}}
}
\examples{
# First example: ratio of independent variables
beta1 <- 0.15
rho1 <- 5.75
delta1 <- 0.22
dnormratio(0, bet = beta1, rho = rho1, delta = delta1)
dnormratio(0.5, bet = beta1, rho = rho1, delta = delta1)
curve(dnormratio(x, bet = beta1, rho = rho1, delta = delta1),
      from = -0.1, to = 0.7)

# Second example: ratio of correlated variables
beta2 <- 2
rho2 <- 2
delta2 <- 2
r2 <- 0.8
dnormratio(0, bet = beta2, rho = rho2, delta = delta2, r = r2)
dnormratio(1, bet = beta2, rho = rho2, delta = delta2, r = r2)
curve(dnormratio(x, bet = beta2, rho = rho2, delta = delta2, r = r2),
      from = -1.5, to = 2.5)

}
\references{
El Ghaziri, A., Bouhlel, N., Sapoukhina, N., Rousseau, D.,
On the importance of non-Gaussianity in chlorophyll fluorescence imaging.
Remote Sensing 15(2), 528 (2023).
\doi{10.3390/rs15020528}

Marsaglia, G. 2006. Ratios of Normal Variables.
Journal of Statistical Software 16.
\doi{10.18637/jss.v016.i04}

Díaz-Francés, E., Rubio, F.J.,
On the existence of a normal approximation to the distribution of the ratio of two independent normal random variables.
Stat Papers 54, 309–323 (2013).
\doi{10.1007/s00362-012-0429-2}

Pham-Gia, T., Turkkan, N., Marchand, E. (2006)
Density of the Ratio of Two Normal Random Variables and Applications,
Communications in Statistics - Theory and Methods, 35:9, 1569-1591.
\doi{10.1080/03610920600683689}
}
\seealso{
\code{\link[=pnormratio]{pnormratio()}}: probability distribution function.

\code{\link[=rnormratio]{rnormratio()}}: sample simulation.

\code{\link[=estparnormratio]{estparnormratio()}}: parameter estimation.
}
\author{
Pierre Santagostini, Angélina El Ghaziri, Nizar Bouhlel
}
