% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah-package.R
\docType{package}
\name{galah}
\alias{galah-package}
\alias{galah}
\title{Biodiversity Data from the GBIF Node Network}
\description{
The Global Biodiversity Information Facility (GBIF; \url{https://www.gbif.org})
provides tools to enable users to find, access, combine and visualise
biodiversity data. \code{galah} is a \code{dplyr} extension package that enables the R
community to directly access data and resources hosted by GBIF and several
of it's subsidiary organisations (known as 'nodes') using \code{dplyr} verbs.

The basic unit of data stored by these infrastructures is
an \strong{occurrence} record, which is an observation of a biological entity at
a specific time and place. However, \code{galah} also facilitates access to
taxonomic information, or associated media such images or sounds,
all while restricting their queries to particular taxa or locations. Users
can specify which columns are returned by a query, or restrict their results
to observations that meet particular quality-control criteria.

For those outside Australia, 'galah' is the common name of
\emph{Eolophus roseicapilla}, a widely-distributed Australian bird species.
}
\section{Functions}{


\strong{Getting Started}
\itemize{
\item \code{\link[=galah_config]{galah_config()}} Set package configuration options
\item \code{\link[=galah_call]{galah_call()}}/\code{\link[=request_data]{request_()}} Start to build a request
}

\strong{Update a request object}
\itemize{
\item \code{\link[=apply_profile]{apply_profile()}} Restrict to data that pass predefined checks
\item \code{\link[=arrange.data_request]{arrange()}} Arrange rows of a query on the server side
\item \code{\link[=authenticate]{authenticate()}} Authenticate your request via OAUTH in the browser
\item \code{\link[=count.data_request]{count()}} Request counts of the specified data type
\item \code{\link[=distinct.data_request]{distinct()}} Keep distinct/unique rows
\item \code{\link[=filter.data_request]{filter()}} Filter records (see also \code{\link[=filter_object_classes]{filter_object_classes}}))
\item \code{\link[=geolocate]{geolocate()}} Spatial filtering of a query
\item \code{\link[=glimpse]{glimpse()}} Get a glimpse of your data
\item \code{\link[=group_by.data_request]{group_by()}} Group counts by one or more fields
\item \code{\link[=identify.data_request]{identify()}} Search for taxonomic identifiers (see also \code{\link[=taxonomic_searches]{taxonomic_searches}})
\item \code{\link[=select.data_request]{select()}} Fields to report information for
\item \code{\link[=slice_head.data_request]{slice_head()}} Choose the first n rows of a download
\item \code{\link[=unnest]{unnest()}} Expand metadata for \code{fields}, \code{lists}, \code{profiles} or \code{taxa}
}

\strong{Create and execute a query}
\itemize{
\item \code{\link[=capture]{capture()}} Convert a request into a \code{prequery} or \code{query}
\item \code{\link[=compound]{compound()}} Convert an object into a \code{query_set} showing all calls needed for evaluation
\item \code{\link[=collapse.data_request]{collapse()}} Convert an object to a valid \code{query}
\item \code{\link[=compute.data_request]{compute()}} Compute a query
\item \code{\link[=collect.data_request]{collect()}} Retrieve a database query
}

\strong{Wrappers for accessing data}
\itemize{
\item \code{\link[=show_all]{show_all()}} & \code{\link[=search_all]{search_all()}} Data for generating filter queries
\item \code{\link[=show_values]{show_values()}} & \code{\link[=search_values]{search_values()}} Show or search for values \emph{within} \code{fields}, \code{profiles}, \code{lists}, \code{collections}, \code{datasets} or \code{providers}
\item \code{\link[=atlas_occurrences]{atlas_occurrences()}} Download occurrence data
\item \code{\link[=atlas_counts]{atlas_counts()}} Get a summary of the number of records or species
\item \code{\link[=atlas_species]{atlas_species()}} Download occurrences grouped by \code{speciesID}
\item \code{\link[=atlas_taxonomy]{atlas_taxonomy()}} Download taxonomic trees
\item \code{\link[=atlas_media]{atlas_media()}} Download media metadata linked to occurrences
\item \code{\link[=collect_media]{collect_media()}} Download media (images and sounds)
}

\strong{Miscellaneous functions}
\itemize{
\item \code{\link[=atlas_citation]{atlas_citation()}} Get a citation for a dataset
\item \code{\link[=read_zip]{read_zip()}} To read data from an earlier download
\item \code{\link[=print.data_request]{print()}} Print functions for galah objects
}
}

\section{Terminology}{


To get the most value from \code{galah}, it is helpful to understand some
terminology. Each occurrence record contains taxonomic
information, and usually some information about the observation itself, such
as its location. In addition to this record-specific information, the living
atlases append contextual information to each record, particularly data from
spatial \strong{layers} reflecting climate gradients or political boundaries. They
also run a number of quality checks against each record, resulting in
\strong{assertions} attached to the record. Each piece of information
associated with a given occurrence record is stored in a \strong{field},
which corresponds to a \strong{column} when imported to an
\code{tibble}. See \code{show_all(fields)} to view valid fields,
layers and assertions, or conduct a search using \code{search_all(fields)}.

Data fields are important because they provide a means to \strong{filter}
occurrence records;  i.e. to return only the information that you need, and
no more. Consequently, much of the architecture of \code{galah} has been
designed to make filtering as simple as possible. The easiest way to do this
is to start a pipe with \code{\link[=galah_call]{galah_call()}} and follow it with the relevant
\code{dplyr} function; starting with \code{\link[=filter.data_request]{filter()}},
but also including \code{\link[=select.data_request]{select()}},
\code{\link[=group_by.data_request]{group_by()}} or others. Functions without
a relevant \code{dplyr} synonym include
\code{\link[=identify.data_request]{identify()}} for choosing a taxon, or
\code{\link[=geolocate]{geolocate()}} for choosing a specific location. By combining different filters,
it is possible to build complex queries to return only the most valuable
information for a given problem.

A notable extension of the filtering approach is to remove records with low
'quality'. All living atlases perform quality control checks on all records
that they store. These checks are used to generate new fields, that can then
be used to filter out records that are unsuitable for particular applications.
However, there are many possible data quality checks, and it is not always
clear which are most appropriate in a given instance. Therefore, \code{galah}
supports data quality \strong{profiles}, which can be passed to
\code{\link[=apply_profile]{apply_profile()}} to quickly remove undesirable records. A full list of
data quality profiles is returned by \code{show_all(profiles)}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://galah.ala.org.au/R/}
  \item Report bugs at \url{https://github.com/AtlasOfLivingAustralia/galah-R/issues}
}

}
\author{
\strong{Maintainer}: Martin Westgate \email{martin.westgate@csiro.au}

Authors:
\itemize{
  \item Dax Kellie \email{dax.kellie@csiro.au}
}

Other contributors:
\itemize{
  \item Shandiya Balasubramaniam \email{shandiya.balasubramaniam@csiro.au} [contributor]
  \item Matilda Stevenson [contributor]
}

}
\keyword{internal}
