% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{authenticate}
\alias{authenticate}
\title{Set up authentication}
\usage{
authenticate(.data, cache_disk = FALSE)
}
\arguments{
\item{.data}{An object of class \code{data_request} or \code{metadata_request}}

\item{cache_disk}{(logical) Should JWT tokens be cached to disk? Defaults
to \code{FALSE}}
}
\value{
An object of the same class as supplied, but with an added
\code{authenticate} slot.
}
\description{
Add an authentication slot to a query. That slot is then used by later
code to determine whether to add an OAuth workflow. It is triggered
automatically within \code{\link[=capture]{capture()}} if the \code{authenticate} argument
of \code{\link[=galah_config]{galah_config()}} is set to \code{TRUE}, but only for occurrence queries
to the Atlas of Living Australia.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}.
}
\examples{
\dontrun{
# use `galah_config()` to set for all occurrence queries
galah_config(authenticate = TRUE)

x <- galah_call() |>
  identify("Wollemia nobilis") |>
  collect()

# use in-pipe for more control
x <- galah_call() |>
  identify("Wollemia nobilis") |>
  authenticate() |>
  collect()
}
}
