% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Omega.R
\name{Omega}
\alias{Omega}
\title{Compute Omega hierarchical}
\usage{
Omega(lambda, genFac = 1, digits = NULL)
}
\arguments{
\item{lambda}{(Matrix) A factor pattern matrix to be analyzed.}

\item{genFac}{(Scalar, Vector) Which column(s) contains the general factor(s). The default value is the first column.}

\item{digits}{(Scalar) The number of digits to round all output to.}
}
\value{
\itemize{
  \item \strong{omegaTotal}: (Scalar) The total reliability of the latent, common factors for the given test.
  \item \strong{omegaGeneral}: (Scalar) The proportion of total variance that is accounted for by the general factor(s).
}
}
\description{
This function computes McDonald's Omega hierarchical to determine the proportions of variance (for a given test) associated with the latent factors and with the general factor.
}
\details{
\itemize{
  \item \strong{Omega Hierarchical}: For a reader-friendly description (with some examples), see the Rodriguez et al., (2016) \emph{Psychological Methods} article. Most of the relevant equations and descriptions are found on page 141.
}
}
\examples{
## Create a bifactor structure
bifactor <- matrix(c(.21, .49, .00, .00,
                     .12, .28, .00, .00,
                     .17, .38, .00, .00,
                     .23, .00, .34, .00,
                     .34, .00, .52, .00,
                     .22, .00, .34, .00,
                     .41, .00, .00, .42,
                     .46, .00, .00, .47,
                     .48, .00, .00, .49),
                   nrow = 9, ncol = 4, byrow = TRUE)

## Compute Omega
Out1 <- Omega(lambda = bifactor)

}
\references{
McDonald, R. P. (1999). \emph{Test theory: A unified approach}. Mahwah, NJ:Erlbaum.

Rodriguez, A., Reise, S. P., & Haviland, M. G. (2016). Evaluating bifactor models: Calculating and interpreting statistical indices. \emph{Psychological Methods, 21}(2), 137.

Zinbarg, R.E., Revelle, W., Yovel, I., & Li. W. (2005). Cronbach's Alpha, Revelle's Beta, McDonald's Omega: Their relations with each and two alternative conceptualizations of reliability. \emph{Psychometrika. }70, 123-133. https://personality-project.org/revelle/publications/zinbarg.revelle.pmet.05.pdf
}
\author{
\itemize{
  \item Casey Giordano (Giord023@umn.edu)
  \item Niels G. Waller (nwaller@umn.edu)
}
}
