% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_data_RoMFCC}
\alias{simulate_data_RoMFCC}
\title{Simulate multivariate functional data with casewise and componentwise contamination}
\usage{
simulate_data_RoMFCC(
  nobs = 1000,
  p = 3,
  p_cellwise = 0,
  p_casewise = 0,
  sd_e = 0.005,
  sd = 0.002,
  T_exp = 0.6,
  outlier = "no",
  M_outlier_case = 0,
  M_outlier_cell = 0,
  OC = "no",
  M_OC = 0,
  P = 100,
  max_n_cellwise = Inf,
  correlation = "decreasing",
  k = 1,
  which_OC = 5
)
}
\arguments{
\item{nobs}{Integer. Number of observations to simulate (default 1000).}

\item{p}{Integer. Number of functional components (variables) (default 3).}

\item{p_cellwise}{Numeric in \eqn{[0,1]}. Probability of cellwise contamination
(componentwise outliers) for each component (default 0).}

\item{p_casewise}{Numeric in \eqn{[0,1]}. Probability of casewise contamination
(entire observation contaminated) (default 0).}

\item{sd_e}{Numeric. Standard deviation of the additive measurement noise (default 0.005).}

\item{sd}{Numeric. Standard deviation scaling of the functional part (default 0.002).}

\item{T_exp}{Numeric in \eqn{(0,1)}. Expansion parameter for phase outliers (default 0.6).}

\item{outlier}{Character. Type of contamination in Phase I sample:
\code{"no"} (no contamination),
\code{"outlier_M"} (mean shift),
\code{"outlier_E"} (exponential shift),
\code{"outlier_P"} (phase shift). Default \code{"no"}.}

\item{M_outlier_case}{Numeric. Magnitude of casewise outlier contamination (default 0).}

\item{M_outlier_cell}{Numeric. Magnitude of cellwise outlier contamination (default 0).}

\item{OC}{Character. Out-of-control model in Phase II data:
\code{"no"} (in control),
\code{"OC_M"} (mean shift),
\code{"OC_E"} (exponential shift),
\code{"OC_P"} (phase shift). Default \code{"no"}.}

\item{M_OC}{Numeric. Magnitude of out-of-control shift (default 0).}

\item{P}{Integer. Number of grid points in each functional profile (default 100).}

\item{max_n_cellwise}{Integer. Maximum number of components per observation
allowed to be cellwise contaminated (default \code{Inf}).}

\item{correlation}{Character. Correlation structure among components:
typically \code{"decreasing"} (default).}

\item{k}{Integer. Correlation parameter (default 1).}

\item{which_OC}{Integer vector. Indices of components subject to out-of-control
shifts in Phase II (default 5).}
}
\value{
A list with two elements:
\describe{
\item{X_mat_list}{A list of length \code{p}, each element a matrix of
dimension \code{nobs × P} with the simulated functional observations.}
\item{ind_out}{A list of length \code{p}, each element containing the
indices of observations contaminated in that component.}
}

Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2024)
Robust Multivariate Functional Control Chart.
\emph{Technometrics}, 66(4):531--547, \url{doi:10.1080/00401706.2024.2327346}.
}
\description{
Generate multivariate functional data under different contamination models
(casewise, componentwise, or both) for use in simulation studies of the
Robust Multivariate Functional Control Chart (RoMFCC) as described in
Capezza, Centofanti, Lepore, and Palumbo (2024).
}
\details{
The generated data mimic dynamic resistance curves (DRCs) in resistance
spot welding processes and allow for controlled introduction of
casewise and/or componentwise outliers, as in the Monte Carlo study
presented in the RoMFCC paper.

The function generates \code{nobs} realizations of a \code{p}-variate functional
quality characteristic observed on an equally spaced grid of size \code{P}.
The underlying process is simulated through a Karhunen–Loève expansion
with eigenfunctions and eigenvalues derived from a specified correlation
structure. Outliers can be introduced at cellwise level (single components),
casewise level (entire observation), or both, using probability parameters
\code{p_cellwise} and \code{p_casewise} and magnitudes
\code{M_outlier_cell}, \code{M_outlier_case}.
Out-of-control shifts in Phase II can be introduced via the \code{OC} argument.

This setup mirrors the simulation design in Section 4 of
Capezza et al. (2024) where RoMFCC was benchmarked against competing
control charts under various contamination scenarios.
}
\examples{
\donttest{
# Simulate uncontaminated data (Phase I)
sim <- simulate_data_RoMFCC(nobs = 200, p = 3, outlier = "no", OC = "no")
str(sim$X_mat_list)

# Simulate with componentwise outliers in Phase I
sim2 <- simulate_data_RoMFCC(nobs = 200, p = 3,
                             p_cellwise = 0.05, M_outlier_cell = 0.03,
                             outlier = "outlier_E")

# Simulate Phase II with a mean shift in one component
sim3 <- simulate_data_RoMFCC(nobs = 200, p = 3,
                             OC = "OC_M", M_OC = 0.04, which_OC = 2)
}

}
