% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{highlight.vertices.spheres}
\alias{highlight.vertices.spheres}
\title{Draw small 3D spheres at given brain mesh vertices. Supports full brain (2 meshes) as well.}
\usage{
highlight.vertices.spheres(surface, vertices, ...)
}
\arguments{
\item{surface}{an fs.surface instance, see \code{\link[fsbrain]{subject.surface}} function. Can also be a hemilist of surfaces, in which case the vertices can be indices over both meshes (in range \code{1..(nv(lh)+nv(rh))}).}

\item{vertices}{vector of positive integers, the vertex indices. Values which are outside of the valid indices for the surface will be silently ignored, making it easier to work with the two hemispheres.}

\item{...}{Parameters passed to \code{\link[fsbrain]{highlight.points.spheres}}.}
}
\description{
Draw small 3D spheres at given brain mesh vertices. Supports full brain (2 meshes) as well.
}
\note{
This function will draw into the current window and add to the scene, so it can be called after visualizing a mesh. See the example.
}
\examples{
\dontrun{
lh_surf = subject.surface('~/data/study1', 'subject1',
 surface = "white", hemi = "lh");
vis.fs.surface(lh_surf, style="semitransparent");
highlight.vertices.spheres(lh_surf,
  vertices = c(3225L, 4300L, 5500L),
  color = c("green", "blue", "red"));
}

}
\seealso{
Other 3d utility functions: 
\code{\link{highlight.points.spheres}()},
\code{\link{vertex.coords}()}
}
\concept{3d utility functions}
