% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework_view.R
\name{view}
\alias{view}
\title{View data in an interactive browser viewer}
\usage{
view(x, title = NULL, max_rows = 5000)
}
\arguments{
\item{x}{The data to view (data.frame, plot, list, function, or other R object)}

\item{title}{Optional title for the view. If NULL, uses the object name.}

\item{max_rows}{Maximum number of rows to display for data frames (default: 5000).}
}
\value{
Invisibly returns NULL. Opens a browser window.
}
\description{
Opens an interactive, browser-based viewer for R objects. This is the primary
function for viewing data frames, plots, lists, and other R objects with
enhanced formatting.
}
\examples{
\donttest{
if (FALSE) {
# View a data frame
view(mtcars)

# View with a title
view(iris, title = "Iris Dataset")

# View a ggplot
library(ggplot2)
p <- ggplot(mtcars, aes(mpg, hp)) + geom_point()
view(p)
}
}

}
