% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai_context.R
\name{ai_generate_context}
\alias{ai_generate_context}
\title{Generate AI Context File}
\usage{
ai_generate_context(
  project_path = ".",
  project_name = NULL,
  project_type = NULL,
  config = NULL
)
}
\arguments{
\item{project_path}{Path to the project directory (default: current directory)}

\item{project_name}{Name of the project (for header)}

\item{project_type}{Project type: "project", "project_sensitive", "course", "presentation"}

\item{config}{Project configuration (if NULL, reads from settings.yml)}
}
\value{
Character string with the complete AI context content
}
\description{
Generates a complete AI context file (CLAUDE.md, AGENTS.md, etc.) from scratch
for a new project. The content is tailored to the project type and configuration.
}
\examples{
\donttest{
if (FALSE) {
# Generate AI context for current project
content <- ai_generate_context()

# Generate for a specific project type
content <- ai_generate_context(project_type = "project_sensitive")
}
}
}
