% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefplot.R
\name{setFixest_coefplot}
\alias{setFixest_coefplot}
\alias{getFixest_coefplot}
\title{Sets the defaults of coefplot}
\usage{
setFixest_coefplot(
  style,
  horiz = FALSE,
  dict = getFixest_dict(),
  keep,
  ci.width = "1\%",
  ci_level = 0.95,
  pt.pch = 20,
  pt.bg = NULL,
  cex = 1,
  pt.cex = cex,
  col = 1:8,
  pt.col = col,
  ci.col = col,
  lwd = 1,
  pt.lwd = lwd,
  ci.lwd = lwd,
  ci.lty = 1,
  grid = TRUE,
  grid.par = list(lty = 3, col = "gray"),
  zero = TRUE,
  zero.par = list(col = "black", lwd = 1),
  pt.join = FALSE,
  pt.join.par = list(col = pt.col, lwd = lwd),
  ci.join = FALSE,
  ci.join.par = list(lwd = lwd, col = col, lty = 2),
  ci.fill = FALSE,
  ci.fill.par = list(col = "lightgray", alpha = 0.5),
  ref.line = "auto",
  ref.line.par = list(col = "black", lty = 2),
  lab.cex,
  lab.min.cex = 0.85,
  lab.max.mar = 0.25,
  lab.fit = "auto",
  xlim.add,
  ylim.add,
  sep,
  bg,
  group = "auto",
  group.par = list(lwd = 2, line = 3, tcl = 0.75),
  main = "Effect on __depvar__",
  value.lab = "Estimate and __ci__ Conf. Int.",
  ylab = NULL,
  xlab = NULL,
  sub = NULL,
  reset = FALSE
)

getFixest_coefplot()
}
\arguments{
\item{style}{A character scalar giving the style of the plot to be used. You
can set styles with the function \code{\link{setFixest_coefplot}}, setting all the default
values of the function. If missing, then it switches to either "default" or "iplot",
depending on the calling function.}

\item{horiz}{A logical scalar, default is \code{FALSE}. Whether to display the confidence
intervals horizontally instead of vertically.}

\item{dict}{A named character vector or a logical scalar. It changes the original variable names
to the ones contained in the \code{dict}ionary. E.g. to change the variables named \code{a} and \code{b3} to
(resp.) \dQuote{$log(a)$} and to \dQuote{$bonus^3$}, use \code{dict=c(a="$log(a)$",b3="$bonus^3$")}.
By default, it is equal to \code{getFixest_dict()}, a default dictionary which can be set with
\code{\link{setFixest_dict}}. You can use \code{dict = FALSE} to disable it. By default \code{dict} modifies the
entries in the global dictionary, to disable this behavior, use "reset" as the first element
(ex: \code{dict=c("reset", mpg="Miles per gallon")}).}

\item{keep}{Character vector. This element is used to display only a subset of variables. This
should be a vector of regular expressions (see \code{\link[base:regex]{base::regex}} help for more info). Each
variable satisfying any of the regular expressions will be kept. This argument is applied post
aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display
only \code{x1} to \code{x9}, then you could use \code{keep = "x[[:digit:]]$"}. If the first character is an
exclamation mark, the effect is reversed (e.g. keep = "!Intercept" means: every variable that
does not contain \dQuote{Intercept} is kept). See details.}

\item{ci.width}{The width of the extremities of the confidence intervals. Default is \code{0.1}.}

\item{ci_level}{Scalar between 0 and 1: the level of the CI. By default it is equal to 0.95.}

\item{pt.pch}{The patch of the coefficient estimates. Default is 1 (circle).}

\item{pt.bg}{The background color of the point estimate (when the \code{pt.pch} is
in 21 to 25). Defaults to NULL.}

\item{cex}{Numeric, default is 1. Expansion factor for the points}

\item{pt.cex}{The size of the coefficient estimates. Default is the other argument \code{cex}.}

\item{col}{The color of the points and the confidence intervals. Default is 1
("black"). Note that you can set the colors separately for each of them
with \code{pt.col} and \code{ci.col}.}

\item{pt.col}{The color of the coefficient estimates. Default is equal to the argument \code{col}.}

\item{ci.col}{The color of the confidence intervals. Default is equal to the argument \code{col}.}

\item{lwd}{General line with. Default is 1.}

\item{pt.lwd}{The line width of the coefficient estimates. Default is equal to
the other argument \code{lwd}.}

\item{ci.lwd}{The line width of the confidence intervals. Default is equal to
the other argument \code{lwd}.}

\item{ci.lty}{The line type of the confidence intervals. Default is 1.}

\item{grid}{Logical, default is \code{TRUE}. Whether a grid should be displayed. You
can set the display of the grid with the argument \code{grid.par}.}

\item{grid.par}{List. Parameters of the grid. The default values are: \code{lty =  3} and \code{col = "gray"}. You can add any graphical parameter that will be passed
to \code{\link[graphics:abline]{graphics::abline}}. You also have two additional arguments: use \code{horiz =  FALSE} to disable the horizontal lines, and use \code{vert = FALSE} to disable the
vertical lines. Eg: \code{grid.par = list(vert = FALSE, col = "red", lwd = 2)}.}

\item{zero}{Logical, default is \code{TRUE}. Whether the 0-line should be emphasized.
You can set the parameters of that line with the argument \code{zero.par}.}

\item{zero.par}{List. Parameters of the zero-line. The default values are
\code{col = "black"} and \code{lwd = 1}. You can add any graphical parameter that will be passed
to \code{\link[graphics:abline]{graphics::abline}}. Example: \code{zero.par = list(col = "darkblue", lwd = 3)}.}

\item{pt.join}{Logical, default is \code{FALSE}. If \code{TRUE}, then the coefficient estimates
are joined with a line.}

\item{pt.join.par}{List. Parameters of the line joining the coefficients. The
default values are: \code{col = pt.col} and \code{lwd = lwd}. You can add any graphical
parameter that will be passed to \code{\link{lines}}. Eg: \code{pt.join.par = list(lty = 2)}.}

\item{ci.join}{Logical default to \code{FALSE}. Whether to join the extremities of
the confidence intervals. If \code{TRUE}, then you can set the graphical parameters
with the argument \code{ci.join.par}.}

\item{ci.join.par}{A list of parameters to be passed to \code{\link[graphics:lines]{graphics::lines}}.
Only used if \code{ci.join=TRUE}. By default it is equal to \code{list(lwd = lwd, col = col, lty = 2)}.}

\item{ci.fill}{Logical default to \code{FALSE}. Whether to fill the confidence intervals
with a color. If \code{TRUE}, then you can set the graphical parameters with the argument \code{ci.fill.par}.}

\item{ci.fill.par}{A list of parameters to be passed to \code{\link[graphics:polygon]{graphics::polygon}}.
Only used if \code{ci.fill=TRUE}. By default it is equal to \code{list(col = "lightgray", alpha = 0.5)}.
Note that \code{alpha} is a special parameter that adds transparency to the color (ranges from 0 to 1).}

\item{ref.line}{Logical or numeric, default is "auto", whose behavior depends
on the situation. It is \code{TRUE} only if: i) interactions are plotted, ii) the
x values are numeric and iii) a reference is found. If \code{TRUE}, then a vertical
line is drawn at the level of the reference value. Otherwise, if numeric a vertical
line will be drawn at that specific value.}

\item{ref.line.par}{List. Parameters of the vertical line on the reference. The
default values are: \code{col = "black"} and \code{lty = 2}. You can add any graphical
parameter that will be passed to \code{\link[graphics:abline]{graphics::abline}}. Eg: \code{ref.line.par = list(lty = 1, lwd = 3)}.}

\item{lab.cex}{The size of the labels of the coefficients. Default is missing.
It is automatically set by an internal algorithm which can go as low as \code{lab.min.cex}
(another argument).}

\item{lab.min.cex}{The minimum size of the coefficients labels, as set by the
internal algorithm. Default is 0.85.}

\item{lab.max.mar}{The maximum size the left margin can take when trying to fit
the coefficient labels into it (only when \code{horiz = TRUE}). This is used in the
internal algorithm fitting the coefficient labels. Default is \code{0.25}.}

\item{lab.fit}{The method to fit the coefficient labels into the plotting region
(only when \code{horiz = FALSE}). Can be \code{"auto"} (the default), \code{"simple"}, \code{"multi"}
or \code{"tilted"}. If \code{"simple"}, then the classic axis is drawn. If \code{"multi"}, then
the coefficient labels are fit horizontally across several lines, such that they
don't collide. If \code{"tilted"}, then the labels are tilted. If \code{"auto"}, an automatic
choice between the three is made.}

\item{xlim.add}{A numeric vector of length 1 or 2. It represents an extension
factor of xlim, in percentage. Eg: \code{xlim.add = c(0, 0.5)} extends \code{xlim} of 50\%
on the right. If of length 1, positive values represent the right, and negative
values the left (Eg: \code{xlim.add = -0.5} is equivalent to \code{xlim.add = c(0.5, 0)}).}

\item{ylim.add}{A numeric vector of length 1 or 2. It represents an extension
factor of ylim, in percentage. Eg: \code{ylim.add = c(0, 0.5)} extends \code{ylim} of 50\%
on the top. If of length 1, positive values represent the top, and negative values
the bottom (Eg: \code{ylim.add = -0.5} is equivalent to \code{ylim.add = c(0.5, 0)}).}

\item{sep}{The distance between two estimates -- only when argument \code{object}
is a list of estimation results.}

\item{bg}{Background color for the plot. By default it is white.}

\item{group}{A list, default is missing. Each element of the list reports the
coefficients to be grouped while the name of the element is the group name. Each
element of the list can be either: i) a character vector of length 1, ii) of
length 2, or ii) a numeric vector. If equal to: i) then it is interpreted as
a pattern: all element fitting the regular expression will be grouped (note that
you can use the special character "^^" to clean the beginning of the names, see
example), if ii) it corresponds to the first and last elements to be grouped,
if iii) it corresponds to the coefficients numbers to be grouped. If equal to
a character vector, you can use a percentage to tell the algorithm to look at
the coefficients before aliasing (e.g. \code{"\%varname"}). Example of valid uses:
\verb{group=list(group_name=\\"pattern\\")}, \verb{group=list(group_name=c(\\"var_start\\", \\"var_end\\"))},
\verb{group=list(group_name=1:2))}. See details.}

\item{group.par}{A list of parameters controlling the display of the group. The
parameters controlling the line are: \code{lwd}, \code{tcl} (length of the tick), \code{line.adj}
(adjustment of the position, default is 0), \code{tick} (whether to add the ticks),
\code{lwd.ticks}, \code{col.ticks}. Then the parameters controlling the text: \code{text.adj}
(adjustment of the position, default is 0), \code{text.cex}, \code{text.font}, \code{text.col}.}

\item{main}{The title of the plot. Default is \code{"Effect on __depvar__"}. You can
use the special variable \verb{__depvar__} to set the title (useful when you set the
plot default with \code{\link{setFixest_coefplot}}).}

\item{value.lab}{The label to appear on the side of the coefficient values. If
\code{horiz = FALSE}, the label appears in the y-axis. If \code{horiz = TRUE}, then it
appears on the x-axis. The default is equal to \code{"Estimate and __ci__ Conf. Int."},
with \verb{__ci__} a special variable giving the value of the confidence interval.}

\item{ylab}{The label of the y-axis, default is \code{NULL}. Note that if \code{horiz =  FALSE}, it overrides the value of the argument \code{value.lab}.}

\item{xlab}{The label of the x-axis, default is \code{NULL}. Note that if \code{horiz =  TRUE}, it overrides the value of the argument \code{value.lab}.}

\item{sub}{A subtitle, default is \code{NULL}.}

\item{reset}{Logical, default is \code{TRUE}. If \code{TRUE}, then the arguments that \emph{are not} set during the call are reset to their "factory"-default values. If \code{FALSE}, on the other hand, arguments that have already been modified are not changed.}
}
\value{
Doesn't return anything.
}
\description{
You can set the default values of most arguments of \code{\link{coefplot}} with this function.
}
\examples{

# coefplot has many arguments, which makes it highly flexible.
# If you don't like the default style of coefplot. No worries,
# you can set *your* default by using the function
# setFixest_coefplot()

# Estimation
est = feols(Petal.Length ~ Petal.Width + Sepal.Length +
                Sepal.Width | Species, iris)

# Plot with default style
coefplot(est)

# Now we permanently change some arguments
dict = c("Petal.Length"="Length (Petal)", "Petal.Width"="Width (Petal)",
         "Sepal.Length"="Length (Sepal)", "Sepal.Width"="Width (Sepal)")

setFixest_coefplot(ci.col = 2, pt.col = "darkblue", ci.lwd = 3,
                   pt.cex = 2, pt.pch = 15, ci.width = 0, dict = dict)

# Tadaaa!
coefplot(est)

# To reset to the default settings:
setFixest_coefplot("all", reset = TRUE)
coefplot(est)

}
\seealso{
\code{\link{coefplot}}
}
