% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{model.matrix.fixest}
\alias{model.matrix.fixest}
\title{Design matrix of a \code{fixest} object}
\usage{
\method{model.matrix}{fixest}(
  object,
  data = NULL,
  type = "rhs",
  sample = "estimation",
  na.rm = FALSE,
  subset = FALSE,
  as.matrix = FALSE,
  as.df = FALSE,
  collin.rm = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{fixest} object. Obtained using the functions \code{\link{femlm}}, \code{\link{feols}} or \code{\link{feglm}}.}

\item{data}{A data.frame or \code{NULL} (the default). If missing or \code{NULL}, then the
original data is obtained by evaluating  the \code{call}.}

\item{type}{Character vector or one sided formula, default is "rhs". Contains the type of
matrix/data.frame to be returned. Possible values are: "lhs", "rhs", "fixef", "iv.rhs1"
(1st stage RHS), "iv.rhs2" (2nd stage RHS), "iv.endo" (endogenous vars.), "iv.exo"
(exogenous vars), "iv.inst" (instruments).}

\item{sample}{Character scalar equal to "estimation" (default) or "original". Only
used when \code{data=NULL} (i.e. the original data is requested). By default,
only the observations effectively used in the estimation are returned (it includes
the observations with NA values or the fully explained by the fixed-effects (FE), or
due to NAs in the weights).

If \code{sample="original"}, all the observations are returned. In that case, if
you use \code{na.rm=TRUE} (which is not the default), you can withdraw the observations
with NA values (and keep the ones fully explained by the FEs).}

\item{na.rm}{Logical scalar, default is \code{FALSE}. Should observations with NAs be
removed from the resulting matrix or data.frame? Note that if \code{data=NULL}}

\item{subset}{Logical scalar or character vector. Default is \code{FALSE}. If \code{TRUE}, then the
matrix created will be restricted only to the variables contained in the argument \code{data},
which can then contain a subset of the variables used in the estimation. If a
character vector, then only the variables matching the elements of the vector via
regular expressions will be created.}

\item{as.matrix}{Logical scalar, default is \code{FALSE}. Whether to coerce the result to a matrix.}

\item{as.df}{Logical scalar, default is \code{FALSE}. Whether to coerce the result to a data.frame.}

\item{collin.rm}{Logical scalar, default is \code{TRUE}. Only used when \code{data=NULL} (i.e.
the data used in the estimation is requested). Whether to remove variables that were
found to be collinear during the estimation. Beware: it does not perform a
collinearity check.}

\item{...}{Not currently used.}
}
\value{
It returns either a vector, a matrix or a data.frame. It returns a vector for the
dependent variable ("lhs"), a data.frame for the fixed-effects ("fixef") and a matrix
for any other type.
}
\description{
This function creates the left-hand-side or the right-hand-side(s) of a \code{\link{femlm}},
\code{\link{feols}} or \code{\link{feglm}} estimation.
}
\examples{

# we use a data set with NAs and fixed-effect singletons
base = setNames(iris, c("y", "x1", "x2", "x3", "fe"))
# adding NAs
base$x1[1:4] = NA
# adding singletons
base$fe = as.character(base$fe)
base$fe[10 + 1:5] = letters[1:5]

# OLS estimation where we remove singletons
est = feols(y ~ x1 + poly(x2, 2) | fe, base, fixef.rm = "singleton")

# by default, we have the data set used in the estimation
head(model.matrix(est))
nrow(model.matrix(est))

# to have the original data set: we need to use sample="original"
head(model.matrix(est, sample = "original"))
nrow(model.matrix(est, sample = "original"))

# we can drop only the NA values (and not the singletons) with na.rm=TRUE
head(model.matrix(est, sample = "original", na.rm = TRUE))
nrow(model.matrix(est, sample = "original", na.rm = TRUE))

#
# Illustration of subset
#

# subset => character vector
head(model.matrix(est, subset = "x1"))

# subset => TRUE, only works with data argument!!
head(model.matrix(est, data = base[, "x1", drop = FALSE], subset = TRUE))



}
\seealso{
See also the main estimation functions \code{\link{femlm}}, \code{\link{feols}} or \code{\link{feglm}}. \code{\link{formula.fixest}}, \code{\link{update.fixest}}, \code{\link{summary.fixest}}, \code{\link{vcov.fixest}}.
}
\author{
Laurent Berge
}
