% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorfield_simulation.R
\name{sim_vf}
\alias{sim_vf}
\title{Simulation from vector fields}
\usage{
sim_vf(
  vf,
  noise = 1,
  noise_warmup = noise,
  chains = 10,
  length = 10000,
  discard = 0.3,
  stepsize = 0.01,
  sparse = 1,
  forbid_overflow = FALSE,
  linear_interp = FALSE,
  inits = matrix(c(stats::runif(chains, min = vf$lims[1], max = vf$lims[2]),
    stats::runif(chains, min = vf$lims[3], max = vf$lims[4])), ncol = 2)
)
}
\arguments{
\item{vf}{A \code{vectorfield} object estimated by \code{\link[=fit_2d_vf]{fit_2d_vf()}}.}

\item{noise}{Relative noise of the simulation. Set this smaller when the simulation is unstable (e.g., when the elements in the diffusion matrix are not finite), and set this larger when the simulation converges too slowly.}

\item{noise_warmup}{The noise used for the warming-up period.}

\item{chains}{How many chains simulations should be performed?}

\item{length}{The simulation length for each chain.}

\item{discard}{How much of the starting part of each chain should be discarded? (Warming-up period.)}

\item{stepsize}{The stepsize for Euler–Maruyama simulation of the system.}

\item{sparse}{A number. How much do you want to sparse the output? When the noise is small, sparse the output may make the density estimation more efficient.}

\item{forbid_overflow}{If \code{TRUE}, when the simulated system runs out of the margins specified in \code{vf}, the system will be moved back to the previous value. This can help to stabilize the simulation. \code{FALSE} by default.}

\item{linear_interp}{Use linear interpolation method to estimate the drift vector (and the diffusion matrix). This can speed up the calculation. If \code{TRUE}, be sure that a linear grid was calculated for the vector field using \verb{<vf> <- add_interp_grid(<vf>)}.}

\item{inits}{The initial values of each chain.}
}
\value{
A matrix of the simulated data.
}
\description{
Parallel computing based on \code{future} is supported. Use \code{future::plan("multisession")} to enable this.
}
