% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{A_data_info}
\alias{A_data_info}
\title{Metadata for Amputee Subjects}
\format{
A data frame with the following variables:
\describe{
  \item{Subject.Code}{Unique identifier for each subject (e.g., TF01, TF02).}
  \item{Age.yrs.}{Age of the subject in years.}
  \item{Gender}{Biological sex (e.g., Male, Female).}
  \item{Mass.kg.}{Body mass in kilograms.}
  \item{Height.m.}{Height in meters.}
  \item{Amputation.side}{Side of amputation (Left or Right).}
  \item{Etiology}{Cause of amputation (e.g., Traumatic, Infection, Dysvascular).}
  \item{Age.of.Amputation..yrs.}{Age at which the subject underwent amputation (years).}
  \item{K.Level}{Medicare Functional Classification Level (e.g., K2, K3), indicating the subject’s mobility level.}
  \item{Prescribed.Prosthesis.Knee}{Type/model of the prosthetic knee prescribed (e.g., C-Leg Obk, Plie FI).}
  \item{Prescribed.Prosthesis.Ankle}{Type/model of the prosthetic ankle prescribed (e.g., AllPro FI, Triton Obk).}
  \item{Socket.Suspension}{Suspension mechanism used for the prosthetic socket (e.g., Suction, Lanyard, Pin Lock).}
  \item{Training.....}{Indicates whether the subject had gait training and, if so, how many sessions (e.g., ``Yes (2)'', ``No'').}
  \item{Hand.rails.}{Indicates whether hand-rails were used during gait assessment (e.g., ``Yes, All'', ``No'').}
}
}
\usage{
A_data_info
}
\description{
Metadata for Amputee Subjects
}
\examples{
# Load the Data
data("A_data_info")
}
\keyword{datasets}
