## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(fgdiR)
library(dplyr)
library(tidyr)
library(magrittr)

## -----------------------------------------------------------------------------
data(P_Data)
data(P_data_info)

## -----------------------------------------------------------------------------
ID <- c(rep("Case", 21), rep("Control", 42))
fgdi_out <- FGDI(P_Data, ID, PVE_I=0.99)

## ----fig.width=6, fig.height=4------------------------------------------------
plot_gait_comparison(1, "Pelvis Tilt (Parkinson)", fgdi_out, P_Data, ID, combined=TRUE)

