% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sankey.R
\name{plot_sankey}
\alias{plot_sankey}
\title{Create a Sankey Plot (robust; aggregates to one row per subject)}
\usage{
plot_sankey(
  prepared_data,
  gnn_results,
  expert_results = NULL,
  top_n_per_side = 2,
  use_profiles = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{prepared_data}{List from \code{prepare_data()}; used for group labels and (optionally) feature mapping.
Needs \code{feature_names} for 3-axis; \code{subject_ids} to align subjects to X.}

\item{gnn_results}{List from \code{train_gnn()}; uses $final_results and $gate_weights.}

\item{expert_results}{Optional list from \code{analyse_experts()}; used only for picking opposed features in 3-axis.}

\item{top_n_per_side}{Integer; number of features per side to define Profile A/B (default 2) for 3-axis.}

\item{use_profiles}{Logical; try 3-axis when possible (default TRUE). If FALSE, always do 2-axis.}

\item{verbose}{Logical; print progress.}
}
\value{
A ggplot object.
}
\description{
Visualises routing from Actual Group -> Assigned Expert (2-axis), or
Actual Group -> Learned Feature Profile -> Assigned Expert (3-axis)
when feature mapping is available.
}
