% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr_est.R
\name{distr_est}
\alias{distr_est}
\alias{norm_est}
\alias{std_est}
\alias{ged_est}
\alias{ald_est}
\alias{snorm_est}
\alias{sstd_est}
\alias{sged_est}
\alias{sald_est}
\title{MLE for Distribution Fitting}
\usage{
distr_est(
  x,
  dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald"),
  fix_mean = NULL,
  fix_sdev = NULL,
  Prange = c(1, 5),
  skip_vcov = FALSE
)

norm_est(x, fix_mean = NULL, fix_sdev = NULL, skip_vcov = FALSE)

std_est(x, fix_mean = NULL, fix_sdev = NULL, skip_vcov = FALSE)

ged_est(x, fix_mean = NULL, fix_sdev = NULL, skip_vcov = FALSE)

ald_est(
  x,
  fix_mean = NULL,
  fix_sdev = NULL,
  Prange = c(1, 5),
  skip_vcov = FALSE
)

snorm_est(x, fix_mean = NULL, fix_sdev = NULL, skip_vcov = FALSE)

sstd_est(x, fix_mean = NULL, fix_sdev = NULL, skip_vcov = FALSE)

sged_est(x, fix_mean = NULL, fix_sdev = NULL, skip_vcov = FALSE)

sald_est(
  x,
  fix_mean = NULL,
  fix_sdev = NULL,
  Prange = c(1, 5),
  skip_vcov = FALSE
)
}
\arguments{
\item{x}{a numeric vector with the data.}

\item{dist}{a character value that specifies the distribution to consider;
available are a normal distribution (\code{"norm"}), a \eqn{t}-distribution
(\code{"std"}), a GED (\code{"ged"}), an ALD (\code{"ald"}), and their
skewed variants (\code{"snorm"}, \code{"sstd"}, \code{"sged"}, \code{"sald"}).}

\item{fix_mean}{optional; for the default \code{NULL}, a location parameter representing
the (unconditional) mean of the distribution is also being estimated; for any
numerical value, however, the mean will be fixed to the corresponding value and
therefore excluded from the estimation itself.}

\item{fix_sdev}{optional; for the default \code{NULL}, a scale parameter representing
the (unconditional) standard deviation of the distribution is also being estimated; for any
numerical value, however, the standard deviation will be fixed to the corresponding value and
therefore excluded from the estimation itself.}

\item{Prange}{a two-element numeric vector, giving the boundaries of the search space
for the shape parameter \eqn{P} in an ALD or its skewed variant.}

\item{skip_vcov}{a logical indicating whether or not the computation of the
variance-covariance matrix should be skipped.}
}
\value{
Returns a list with the following elements.
}
\description{
Given a vector of values assumed to stem from
independent and identically distributed (iid) random variables, fit a selection
of distributions, from the normal distribution, the \eqn{t}-distribution, the
generalized error distribution (GED), the average Laplace distribution (ALD), and
their skewed variants, to the data using maximum-likelihood estimation (MLE).
}
\details{
Let \eqn{x} be an individual observation. Let \eqn{\mu} a real-valued location
parameter, representing the unconditional mean of the distribution, and
\eqn{\sigma} a real-valued scale parameter, representing the unconditional
standard deviation. Generally, let \eqn{\theta} be a vector with all parameters
of the underlying distribution. The likelihood of \eqn{x} is given through
\deqn{L_x^{\text{norm}}(\theta)=\frac{\sigma^{-1}}{\sqrt{2\pi}}\exp\left(-\frac{1}{2}\left(\frac{x-\mu}{\sigma}\right)^2\right)}
for a normal distribution,
\deqn{L_x^{\text{std}}(\theta)=\frac{\sigma^{-1}\Gamma\left(\frac{\nu + 1}{2}\right)}{\Gamma\left(\frac{\nu}{2}\right)\sqrt{\pi(\nu-2)}}\left[1+\frac{1}{\nu - 2}\left(\frac{x-\mu}{\sigma}\right)^2\right]^{-\frac{\nu + 1}{2}}}
for a \eqn{t}-distribution with \eqn{\nu} as the degrees of freedom and \eqn{\Gamma}
as the gamma function,
\deqn{L_x^{\text{ged}}(\theta)=\frac{\sigma^{-1}\beta}{2}\sqrt{\frac{C_{\Gamma,3}}{C_{\Gamma,1}^3}} \exp\left\{-\left|\frac{x-\mu}{\sigma}\right|^{\beta}\left(\frac{C_{\Gamma,3}}{C_{\Gamma,1}}\right)^{\frac{\beta}{2}}\right\}}
for a GED with \eqn{\beta} as its real-valued shape and with \eqn{C_{\Gamma,i}=\Gamma\left(\frac{i}{\beta}\right)}, \eqn{i\in\left\{1,3\right\}},
and in
\deqn{L_x^{\text{ald}}(\theta)=\frac{\sigma^{-1}sB}{2}\exp\left(-s\left|\frac{x-\mu}{\sigma}\right|\right)\sum_{j=0}^{P}c_j\left(s\left|\frac{x-\mu}{\sigma}\right|\right)^j}
for an ALD with \eqn{P} as its discrete shape, where \eqn{s = \sqrt{2(P+1)}},
\deqn{B=2^{-2P} {{2P}\choose{P}}, \hspace{4mm} P \geq 0,}
and
\deqn{c_{j}=\frac{2(P-j + 1)}{j(2P-j+1)}c_{j-1}, \hspace{4mm} j =2,3,\dots,P,}
with \eqn{c_0 = c_1 = 1}.
The individual-observation likelihoods for the skewed variants are derived analogously
from the idea by Fernandez and Steel (1998). The log-likelihoods to maximize
over are then just the sum of the log-transformed likelihoods for each observation.

\code{distr_est} is a general purpose distribution fitting function, where the
distribution can be selected through the argument \code{dist}. \code{norm_est},
\code{std_est}, \code{ged_est}, \code{ald_est}, \code{snorm_est},
\code{sstd_est}, \code{sged_est}, and \code{sald_est} are wrappers around
\code{distr_est} in order to directly provide fitting functions for the
different distributions available in this package.
}
\examples{
# Draw obs. from GED and implement standard deviation 1.2
# and mean 3.1
x <- rged_s(4000, shape = 1.5) * 1.2 + 3.1
# Fit GED
ged_est(x)
# Fit GED differently using distr_est()
distr_est(x, dist = "ged")
# Fit GED while fixing mean and standard deviation
ged_est(x, fix_mean = 3.1, fix_sdev = 1.2)
# Fit another distribution
sstd_est(x)

}
\references{
\itemize{
\item{Fernandez, C., & Steel, M. F. J. (1998). Bayesian Modeling of Fat Tails and Skewness.
Journal of the American Statistical Association,
93(441), 359–371. DOI: 10.1080/01621459.1998.10474117.}
}
}
