% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_menu.R
\name{select_menu}
\alias{select_menu}
\title{Display a Menu for User Selection}
\usage{
select_menu(
  choices,
  title = NULL,
  msg = "Enter one or more numbers, or an empty line to open files: ",
  width = getOption("width")
)
}
\arguments{
\item{choices}{character: vector of options to display to the user. Each choice will be prefixed with a numbered label.}

\item{title}{character: optional string to display as the title of the menu. Default is \code{NULL}, meaning no title is displayed.}

\item{msg}{character: string specifying the prompt message for user input. Default is \code{"Enter one or more numbers, or an empty line to open files: "}.}

\item{width}{integer: specifying the maximum line width for displaying the menu. Defaults to the value of the \code{width} option (\code{getOption("width")}).}
}
\value{
A character vector of selected choices, or \code{NULL} if the user enters an empty line.
}
\description{
Presents a list of choices to the user, allowing them to select one or more options by entering numbers.
If the user inputs an empty line, the function skips the selection and returns \code{NULL}.
}
\details{
This documentation was created with the support of ChatGPT.
}
\examples{
\dontrun{
# Example usage:
options <- c("Apple", "Banana", "Cherry", "Date")
selected <- select_menu(options, title = "Choose your fruits:")
cat("You selected:", paste(selected, collapse = ", "), "\n")
}

}
\seealso{
Based on \href{https://github.com/r-lib/remotes/blob/main/R/deps.R}{\code{select_menu()} in the package \code{remotes}}
}
