% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{polychoric}
\alias{polychoric}
\title{Polychoric Correlation}
\usage{
polychoric(x, y)
}
\arguments{
\item{x}{A polytomous vector (categorical ordinal variable)}

\item{y}{A polytomous vector (categorical ordinal variable)}
}
\value{
The polychoric correlation coefficient between x and y
}
\description{
Calculate the polychoric correlation coefficient between two polytomous (categorical ordinal) variables.
Polychoric correlation estimates the correlation between two theorized normally distributed
continuous latent variables from two observed ordinal variables.
}
\details{
This function handles missing values (coded as -1 or NA) using pairwise deletion.
The estimation uses maximum likelihood approach with Brent's method for optimization.
}
\examples{
# Example with simulated data
set.seed(123)
x <- sample(1:5, 100, replace = TRUE)
y <- sample(1:4, 100, replace = TRUE)
polychoric(x, y)

}
