% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_tolerance_weight.R
\name{linear_follow_up_weight}
\alias{linear_follow_up_weight}
\title{Weights for tolerance and toxicity events using linear function of time}
\usage{
linear_follow_up_weight(
  now_time,
  recruited_time,
  tox,
  max_time,
  tox_has_weight_1 = TRUE
)
}
\arguments{
\item{now_time}{the time now}

\item{recruited_time}{vector of recruitment times for patients}

\item{tox}{integer vector of toxicity variables for patients, 1 means tox}

\item{max_time}{the maximum window of evaluation for}

\item{tox_has_weight_1}{logical, TRUE to set the weight for tox to 1
identically}
}
\value{
numerical vector of weights
}
\description{
Weights for tolerance and toxicity events using linear function of time
}
\examples{
linear_follow_up_weight(
  now_time = 10,
  recruited_time = 4:7,
  tox = c(0, 0, 0, 1),
  max_time = 6,
  tox_has_weight_1 = TRUE
)

linear_follow_up_weight(
  now_time = 10,
  recruited_time = 4:7,
  tox = c(0, 0, 0, 1),
  max_time = 6,
  tox_has_weight_1 = FALSE
)
}
