% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{fit}
\alias{fit}
\title{Fit a dose-finding model.}
\usage{
fit(selector_factory, outcomes, ...)
}
\arguments{
\item{selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{outcomes}{Outcome string. See \code{\link{parse_phase1_outcomes}}.}

\item{...}{Extra args are passed onwards.}
}
\value{
Object of generic type \code{\link{selector}}.
}
\description{
Fit a dose-finding model to some outcomes.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
model <- get_dfcrm(skeleton = skeleton, target = target)
fit <- model \%>\% fit('1NNN 2NTN')
fit \%>\% recommended_dose()  # Etc
}
\seealso{
\code{\link{selector}}, \code{\link{selector_factory}}
}
