% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose_escalation_table.R
\name{dose_escalation_table}
\alias{dose_escalation_table}
\title{Plot a table of dose escalation vs de-escalation vs stop decisions}
\usage{
dose_escalation_table(
  mod,
  stop_at_n_in_dose_level,
  dose = as.integer(2),
  stop_label = "DU"
)
}
\arguments{
\item{mod}{object of type \code{selector_factory} like that returned by
\code{get_dfcrm} or \code{get_mtpi2}, for instance.}

\item{stop_at_n_in_dose_level}{integer, maximum dose sample size}

\item{dose}{integer, current dose}

\item{stop_label, }{the label given to the outcome where no dose is selected}
}
\value{
a plot
}
\description{
Plot a table of dose escalation vs de-escalation vs stop decisions
}
\examples{
mymod <- get_mtpi2(num_doses = 9, target = 0.4, alpha = 2, beta = 2,
                   epsilon1 = 0.15, epsilon2 = 0.03,
                   exclusion_certainty = 0.8)
dose_escalation_table(
  mod = mymod,
  stop_at_n_in_dose_level = 15
)
}
\author{
Conor Norris, Kristian Brock
}
