% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-package.R
\name{get_enrichment_options}
\alias{get_enrichment_options}
\alias{print.enrichment_options}
\title{Generic method for getting available options for the enrichment
of objects}
\usage{
get_enrichment_options(object, option, all_options)
}
\arguments{
\item{object}{the object to be enriched}

\item{option}{a character vector listing the options for enriching
the object}

\item{all_options}{if \code{TRUE} then output a data frame with the
available enrichment options, their descriptions, the names of
the components that each option results in, and the names of
the corresponding \code{compute} functions.}
}
\value{
if \code{all_options = TRUE} then an object of class
    \code{enrichment_options} is returned, otherwise if
    \code{option} is specified the output is a character vector
    with the names of the functions that compute the enrichment
    components
}
\description{
Generic method for getting available options for the enrichment
of objects
}
\details{
A check is being made whether the requested option is
    available. No check is being made on whether the functions that
    produce the components exist.
}
\seealso{
\code{\link{enrich.glm}}, \code{\link{enrich.family}}, \code{\link{enrich.link-glm}}, \code{\link{enrich.betareg}}
}
