% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_gg.R
\name{ggsrc}
\alias{ggsrc}
\title{Add source file label to a ggplot object}
\usage{
ggsrc(plt, span = 2, size = 8, col = "grey55", lab = NULL, omit = "")
}
\arguments{
\item{plt}{A ggplot object.}

\item{span}{\verb{<num>} Number of lines: either 1 or 2.}

\item{size}{\verb{<num>} Text size.}

\item{col}{\verb{<chr>} Colour of the text.}

\item{lab}{\verb{<chr>} Custom label to use instead of the default.}

\item{omit}{\verb{<chr>} Text to omit from the label.}
}
\value{
A ggplot object with the added label.
}
\description{
Add a label with the current source file path and run time to a ggplot object.
}
\examples{
p = mtcars |> ggxy(mpg,hp)
p |> ggsrc()
p |> ggsrc(lab="My label")
}
