% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div.r
\name{alpha_div}
\alias{alpha_div}
\title{Alpha Diversity Wrapper Function}
\usage{
alpha_div(
  counts,
  metric,
  norm = "percent",
  cutoff = 10,
  digits = 3L,
  tree = NULL,
  cpus = n_cpus()
)
}
\arguments{
\item{counts}{A numeric matrix of count data where each column is a
feature, and each row is a sample. Any object coercible with
\code{as.matrix()} can be given here, as well as \code{phyloseq}, \code{rbiom},
\code{SummarizedExperiment}, and \code{TreeSummarizedExperiment} objects.}

\item{metric}{The name of an alpha diversity metric. One of \code{c('ace', 'berger', 'brillouin', 'chao1', 'faith', 'fisher', 'inv_simpson', 'margalef', 'mcintosh', 'menhinick', 'observed', 'shannon', 'simpson', 'squares')}. Case-insensitive and partial name matching is supported.
Programmatic access via \code{list_metrics('alpha')}.}

\item{norm}{Normalize the incoming counts. Options are:
\describe{
\item{\code{norm = "percent"} - }{ Relative abundance (sample abundances sum to 1). }
\item{\code{norm = "binary"}  - }{ Unweighted presence/absence (each count is either 0 or 1). }
\item{\code{norm = "clr"}     - }{ Centered log ratio. }
\item{\code{norm = "none"}    - }{ No transformation. }
}
Default: \code{'percent'}, which is the expected input for these formulas.}

\item{cutoff}{The maximum number of observations to consider "rare".
Default: \code{10}.}

\item{digits}{Precision of the returned values, in number of decimal
places. E.g. the default \code{digits=3} could return \code{6.392}.}

\item{tree}{A \code{phylo}-class object representing the phylogenetic tree for
the OTUs in \code{counts}. The OTU identifiers given by \code{colnames(counts)}
must be present in \code{tree}. Can be omitted if a tree is embedded with
the \code{counts} object or as \code{attr(counts, 'tree')}.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A numeric vector.
}
\description{
Alpha Diversity Wrapper Function
}
\details{
\subsection{Integer Count Requirements}{

A frequent and critical error in alpha diversity analysis is providing the
wrong type of data to a metric's formula. Some indices are mathematically
defined based on counts of individuals and require raw, integer abundance
data. Others are based on proportional abundances and can accept either
integer counts (which are then converted to proportions) or pre-normalized
proportional data. Using proportional data with a metric that requires
integer counts will return an error message.
\subsection{Requires Integer Counts Only}{
\itemize{
\item Chao1
\item ACE
\item Squares Richness Estimator
\item Margalef's Index
\item Menhinick's Index
\item Fisher's Alpha
\item Brillouin Index
}
}

\subsection{Can Use Proportional Data}{
\itemize{
\item Observed Features
\item Shannon Index
\item Gini-Simpson Index
\item Inverse Simpson Index
\item Berger-Parker Index
\item McIntosh Index
\item Faith's PD
}
}

}
}
\examples{
    # Example counts matrix
    ex_counts
    
    # Shannon diversity values
    alpha_div(ex_counts, 'Shannon')
    
    # Chao1 diversity values
    alpha_div(ex_counts, 'c')
    
    # Faith PD values
    alpha_div(ex_counts, 'faith', tree = ex_tree)
    
    
}
