% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxiliaryFunctions.R
\name{clusterBayesfactor}
\alias{clusterBayesfactor}
\title{Calculate Clustering Bayes Factors for when using the Stochastic Block Model
as an edge prior}
\usage{
clusterBayesfactor(fit, type = "complement", b1 = NULL, b2 = NULL)
}
\arguments{
\item{fit}{A fitted object of class \code{easybgm} or \code{bgms} containing
the clustering results.}

\item{type}{A character string specifying the type of Bayes factor to calculate.
Options are \code{"point"} or \code{"complement"}. Defaults to \code{"complement"}.}

\item{b1}{Indicates the number of clusters according to the first point hypothesis,
required for \code{type = "point"}.}

\item{b2}{Indicates the number of clusters according to the second point hypothesis,
required for \code{type = "point"}.}
}
\value{
A numeric value representing the Bayes factor. When type is \code{"point"},
the Bayes factor represents evidence in favor of \code{b1} clusters against \code{b2}
clusters. When type is \code{"complement"}, the Bayes factor represents evidence
in favor of clustering (i.e., more than one cluster) against no clustering.
}
\description{
This function calculates Bayes factors to evaluate evidence in favor of
clustering for models fitted with the \code{bgms} package (i.e., with arguments
\code{package = "bgms"} and \code{edge_prior = "Stochastic-Block"} within
the \code{easybgm} function). The function supports two types of Bayes factors:
Bayes factors between two point hypothesized number of clusters (\code{b1} and \code{b2}),
and Bayes factor of the hypothesis of clustering (i.e., the complement hypothesis)
against the hypothesis of no clustering (i.e., the null, which simply means
that the network exibits one global cluster).
}
