# Generated by 02-duckplyr_df-methods.R
#' @export
group_split.duckplyr_df <- function(.tbl, ..., .keep = TRUE, keep = deprecated()) {
  if (!missing(keep)) {
    lifecycle::deprecate_warn("1.0.0", "group_split(keep = )", "group_split(.keep = )", always = TRUE)
    .keep <- keep
  }

  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "No relational implementation for {.code group_split()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.tbl, duckplyr_error)

  group_split <- dplyr$group_split.data.frame
  out <- group_split(.tbl, ..., .keep = .keep)
  return(out)

  # dplyr implementation
  if (!missing(keep)) {
    lifecycle::deprecate_stop(
      "1.0.0",
      "group_split(keep = )",
      "group_split(.keep = )"
    )
  }
  data <- group_by(.tbl, ...)
  group_split_impl(data, .keep = .keep)
}

duckplyr_group_split <- function(.tbl, ...) {
  try_fetch(
    .tbl <- as_duckplyr_df_impl(.tbl),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_split(.tbl, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
