# Generated by 02-duckplyr_df-methods.R
#' @export
group_keys.duckplyr_df <- function(.tbl, ...) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "No relational implementation for {.code group_keys()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.tbl, duckplyr_error)

  group_keys <- dplyr$group_keys.data.frame
  out <- group_keys(.tbl, ...)
  return(out)

  # dplyr implementation
  if (dots_n(...) > 0) {
    lifecycle::deprecate_stop(
      "1.0.0",
      "group_keys(... = )",
      details = "Please `group_by()` first"
    )
  }
  out <- group_data(.tbl)
  group_keys0(out)
}

duckplyr_group_keys <- function(.tbl, ...) {
  try_fetch(
    .tbl <- as_duckplyr_df_impl(.tbl),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_keys(.tbl, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
