# Generated by 02-duckplyr_df-methods.R
#' @rdname select.duckplyr_df
#' @export
select.duckplyr_df <- function(.data, ...) {
  force(.data)

  error_call <- dplyr_error_call()

  loc <- tidyselect::eval_select(
    expr(c(...)),
    data = .data,
    error_call = error_call
  )

  exprs <- exprs_from_loc(.data, loc)

  duckplyr_error <- rel_try(list(name = "select", x = .data, args = try_list(dots = enquos(...))),
    # We could count and create a zero-col data frame, but we can't
    # create a duckplyr frame from it anyway.
    #' @section Fallbacks:
    #' There is no DuckDB translation in `select.duckplyr_df()`
    #' - with no expression,
    #' - nor with a selection that returns no columns.
    #'
    #' These features fall back to [dplyr::select()], see `vignette("fallback")` for details.
    "Zero-column result set not supported." = (length(exprs) == 0),
    {
      rel <- duckdb_rel_from_df(.data)
      out <- exprs_project(rel, exprs, .data)
      return(out)
    }
  )


  # dplyr forward
  check_prudence(.data, duckplyr_error)

  select <- dplyr$select.data.frame
  out <- select(.data, ...)
  return(out)

  # dplyr implementation
  error_call <- dplyr_error_call()

  loc <- tidyselect::eval_select(
    expr(c(...)),
    data = .data,
    error_call = error_call
  )
  loc <- ensure_group_vars(loc, .data, notify = TRUE)

  out <- dplyr_col_select(.data, loc)
  out <- set_names(out, names(loc))

  out
}

duckplyr_select <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- select(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
