% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-validation.R
\name{validate_primary_keys}
\alias{validate_primary_keys}
\title{Validate Primary Keys}
\usage{
validate_primary_keys(dt, keys)
}
\arguments{
\item{dt}{A data.table.}

\item{keys}{Character vector of column names to test as primary keys.}
}
\value{
An S3 object of class \code{validate_pk} containing:
\describe{
\item{table_name}{Name of the input table from the original call}
\item{keys}{Character vector of column names tested}
\item{is_primary_key}{Logical: TRUE if keys uniquely identify all rows}
\item{n_rows}{Total number of rows in the table}
\item{n_unique_keys}{Number of distinct key combinations}
\item{n_duplicate_keys}{Number of key combinations that appear more than once}
\item{duplicate_keys}{A data.table of duplicated key values with their counts}
\item{has_numeric_keys}{Logical: TRUE if any key column is of type double}
}
}
\description{
Tests whether a set of columns constitute primary keys of a data.table,
i.e., whether they uniquely identify every row in the table.
}
\details{
A warning is issued if any key column is numeric (double), as floating-point
values can cause unexpected behavior in exact matching operations.
}
\examples{
library(data.table)
dt <- data.table(
  id = c(1L, 2L, 3L, 4L),
  group = c("A", "A", "B", "B"),
  value = c(10, 20, 30, 40)
)

# Single column that IS a primary key
validate_primary_keys(dt, "id")

# Single column that is NOT a primary key
validate_primary_keys(dt, "group")

# Composite key that IS a primary key
validate_primary_keys(dt, c("group", "id"))

}
\seealso{
\code{\link[=validate_join]{validate_join()}} for join relationship analysis,
\code{\link[=validate_var_relationship]{validate_var_relationship()}} for variable relationship analysis
}
