% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string-cleaning.R
\name{clean_var_names}
\alias{clean_var_names}
\title{Clean Variable Names}
\usage{
clean_var_names(text)
}
\arguments{
\item{text}{Character vector of variable names to clean.}
}
\value{
Character vector of cleaned variable names containing only lowercase
letters, digits, and underscores.
}
\description{
Standardizes variable names by trimming whitespace, converting to lowercase
ASCII, replacing all non-alphanumeric characters with underscores, and
removing leading/trailing underscores.
}
\examples{
clean_var_names(c("Sales Revenue", "cost-of-goods", " margin "))
# Returns: c("sales_revenue", "cost_of_goods", "margin")

}
