% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_ht.R
\name{prediction_annotation}
\alias{prediction_annotation}
\title{Annotate Predsictions Information}
\usage{
prediction_annotation(
  sorted_dat,
  target_lab,
  task = c("classification", "regression"),
  label_map = NULL,
  label_map_colors = NULL,
  type_palette = "Dark2",
  label_palette = "OrRd",
  n_label_color = 9,
  prop_palette = gray,
  n_prop_colors = 11,
  gap_mm = unit(1, "mm")
)
}
\arguments{
\item{sorted_dat}{List from \code{sorted_mat()}, containing \code{dat_sorted} with predictions.}

\item{target_lab}{Name of true label column in \code{dat_sorted}.}

\item{task}{Character. Type of task: "classification" or "regression".}

\item{label_map}{Optional named vector to map raw labels to new labels.}

\item{label_map_colors}{Optional named vector of colors for mapped labels.}

\item{type_palette}{RColorBrewer palette for data_type (default "Dark2").}

\item{label_palette}{Function or vector of colors for true and predicted value (default OrRd).}

\item{n_label_color}{Number of colors for probability palette (default 9).}

\item{prop_palette}{Function or vector of colors for probability gradient (default gray).}

\item{n_prop_colors}{Number of colors for probability palette (default 11).}

\item{gap_mm}{Unit for gap between annotations (default \code{unit(1, "mm")} ).}
}
\value{
A \code{rowAnnotation} object for predictions and truth.
}
\description{
Creates row annotations showing predicted vs true class labels and probabilities,
with optional data_type coloring.
}
\keyword{internal}
