% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFrameSortDS.R
\name{dataFrameSortDS}
\alias{dataFrameSortDS}
\title{Sorting and reordering data frames, vectors or matrices}
\usage{
dataFrameSortDS(
  df.name = NULL,
  sort.key.name = NULL,
  sort.descending,
  sort.method
)
}
\arguments{
\item{df.name}{a character string providing the name for the serverside
data.frame to be sorted. This parameter is fully specified by the equivalent
argument in ds.dataFrameShort and further details can be found at
help("ds.dataFrameSort").}

\item{sort.key.name}{a character string providing the name for the sort key.
This will be a serverside vector which may sit inside the data frame to be
sorted or independently in the serverside analysis environment. But, if it
sits outside the data frame it must then be the same length as the data frame.
This parameter is fully specified by the equivalent argument
in ds.dataFrameShort and further details can be found at help("ds.dataFrameSort").}

\item{sort.descending}{logical, if TRUE the data.frame will be sorted
by the sort key in descending order. Default = FALSE (sort order ascending).
This parameter is fully specified by the equivalent argument
in ds.dataFrameShort and further details can be found at help("ds.dataFrameSort").}

\item{sort.method}{A character string taking one of the values: "default",
"d", "alphabetic", "a", "numeric", "n", or NULL. Default value is "default".
This parameter is fully specified by the equivalent argument
in ds.dataFrameShort and further details can be found at help("ds.dataFrameSort").}
}
\value{
the appropriately re-sorted data.frame will be written to the serverside
R environment as a data.frame named according to the <newobj> argument(or with
default name 'dataframesort.newobj') if no name is specified
}
\description{
Sorts a data frame using a specified alphanumeric or numeric sort key
}
\details{
Serverside assign function dataFrameSortDS is called by
clientside function ds.dataFrameSort.  A vector or a matrix can be
added to, or coerced into, a data frame (using function [ds.dataFrame])
and this means that they too can be sorted/reordered using ds.dataFrameSort.
Fundamentally, the function [ds.dataFrameSort] will sort a specified
data frame on the serverside using a sort key also on the serverside.
For more details see help for the clientside function: [ds.dataFrameShort]
}
\author{
Paul Burton, with critical error identification by
Leire Abarrategui-Martinez, for DataSHIELD Development Team, 2/4/2020
}
