% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fun.R
\name{plot_fun}
\alias{plot_fun}
\title{An example function to plot some plot}
\usage{
plot_fun(
  a = NA,
  b = TRUE,
  c = TRUE,
  d = 1,
  e = FALSE,
  f = FALSE,
  g = FALSE,
  c1 = c(rev(pal_seeblau), "white", pal_grau, "black", Bordeaux),
  c2 = "black"
)
}
\arguments{
\item{a}{Numeric (integer > 0). 
Default: \code{a = NA}.}

\item{b}{Boolean. 
Default: \code{b = TRUE}.}

\item{c}{Boolean. 
Default: \code{c = TRUE}.}

\item{d}{Numeric (double). 
Default: \code{d = 1.0}.}

\item{e}{Boolean. 
Default: \code{e = FALSE}.}

\item{f}{Boolean. 
Default: \code{f = FALSE}.}

\item{g}{Boolean. 
Default: \code{g = FALSE}.}

\item{c1}{A color palette (as a vector). 
Default: \code{c1 = c(rev(pal_seeblau), "white", pal_grau, "black", Bordeaux)} 
(i.e., using colors of the \strong{unikn} package by default).}

\item{c2}{A color (e.g., color name, as character). 
Default: \code{c2 = "black"}.}
}
\description{
\code{plot_fun} provides options for plotting a plot.
}
\details{
\code{plot_fun} is deliberately kept cryptic and obscure to illustrate 
how function parameters can be explored. 

\code{plot_fun} also shows that brevity in argument names should not 
come at the expense of clarity. In fact, transparent argument names 
are absolutely essential for understanding and using a function. 

\code{plot_fun} currently requires \code{pal_seeblau}, \code{pal_grau}, and 
\code{Bordeaux} (from the \strong{unikn} package) for its default colors.
}
\examples{
# Basics: 
plot_fun()

# Exploring options: 
plot_fun(a = 3, b = FALSE, e = TRUE)
plot_fun(a = 4, f = TRUE, g = TRUE, c1 = c("steelblue", "white", "firebrick"))

}
\seealso{
\code{\link{plot_fn}} for a related function; 
\code{\link{pal_ds4psy}} for color palette.

Other plot functions: 
\code{\link{plot_charmap}()},
\code{\link{plot_chars}()},
\code{\link{plot_circ_points}()},
\code{\link{plot_fn}()},
\code{\link{plot_n}()},
\code{\link{plot_text}()},
\code{\link{plot_tiles}()},
\code{\link{theme_clean}()},
\code{\link{theme_ds4psy}()},
\code{\link{theme_empty}()}
}
\concept{plot functions}
