% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_util_fun.R
\docType{data}
\name{base_digits}
\alias{base_digits}
\title{Base digits: Sequence of numeric symbols (as named vector)}
\format{
An object of class \code{character} of length 62.
}
\usage{
base_digits
}
\description{
\code{base_digits} provides numeral symbols (digits) 
for notational place-value systems with arbitrary bases 
(as a named character vector).
}
\details{
Note that the elements (digits) are character symbols 
(i.e., numeral digits "0"-"9", "A"-"F", etc.), 
whereas their names correspond to their 
numeric values (from 0 to \code{length(base_digits) - 1}). 

Thus, the maximum base value in conversions by 
\code{\link{base2dec}} or \code{\link{dec2base}} 
is \code{length(base_digits)}.
}
\examples{
base_digits          # named character vector, zero-indexed names
length(base_digits)  # 62 (maximum base value)
base_digits[10]      # 10. element ("9" with name "9") 
base_digits["10"]    # named element "10" ("A" with name "10")
base_digits[["10"]]  # element named "10" ("A")

}
\seealso{
\code{\link{base2dec}} converts numerals in some base into decimal numbers; 
\code{\link{dec2base}} converts decimal numbers into numerals in another base; 
\code{\link{as.roman}} converts integers into Roman numerals.

Other numeric functions: 
\code{\link{base2dec}()},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}

Other utility functions: 
\code{\link{base2dec}()},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{is_vect}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}
}
\concept{numeric functions}
\concept{utility functions}
\keyword{datasets}
