% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twomode_Degree.R
\name{netstats_tm_degreecent}
\alias{netstats_tm_degreecent}
\title{Compute Degree Centrality Values for Two-Mode Networks}
\usage{
netstats_tm_degreecent(net, level1 = TRUE)
}
\arguments{
\item{net}{A two-mode adjacency matrix}

\item{level1}{TRUE/FALSE. TRUE indicates that the degree centrality will be computed for level 1 nodes. FALSE indicates that the degree centrality will be computed for level 2 nodes. Set to TRUE by default.}
}
\value{
The vector of two-mode level-specific degree centrality values.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function computes the degree centrality values for two-mode
networks following Knoke and Yang (2020). The computed degree centrality is
based on the specified level. That is, in an affiliation matrix, the density
can be computed on the symmetric \emph{g x g} co-membership matrix of
level 1 actors (e.g., medical doctors) or on the symmetric \emph{h x h} shared actors matrix for level 2
groups (e.g., hospitals) based on their shared members.
}
\details{
Following Knoke and Yang (2020), the computation of degree for two-mode affiliation networks
is level specific. A two-mode affiliation matrix \emph{X} with dimensions \emph{g x h}, where \emph{g} is
the number of level 1 nodes (e.g., medical doctors) and \emph{h} is the number of level 2 nodes
(i.e., hospitals). If the function is defined on the level 1 nodes,
the degree centrality of an actor \emph{i} is computed as:
\deqn{ X^{G} = XX^{T} }
\deqn{ C_{D}^{G}(g_{i}) = \sum_{i = 1}^{g}  x_{ij}^{g} \quad (i \neq j)}
In contrast, if it is defined on the level 2 nodes, the degree centrality of
an actor \emph{i} is computed as:
\deqn{ X^{H} = X^{T}X }
\deqn{ C_{D}^{H}(h_{i}) = \sum_{i = 1}^{h}  x_{ij}^{h} \quad (i \neq j)}
}
\examples{
#Replicating the biparitate graph presented in Knoke and Yang (2020: 109)
knoke_yang_PC <- matrix(c(1,1,0,0, 1,1,0,0,
                          1,1,1,0, 0,0,1,1,
                          0,0,1,1), byrow = TRUE,
                          nrow = 5, ncol = 4)
colnames(knoke_yang_PC) <- c("Rubio-R","McConnell-R", "Reid-D", "Sanders-D")
rownames(knoke_yang_PC) <- c("UPS", "MS", "HD", "SEU", "ANA")
netstats_tm_degreecent(knoke_yang_PC, level1 = TRUE) #this value matches the book
netstats_tm_degreecent(knoke_yang_PC, level1 = FALSE) #this value matches the book
}
\references{
Knoke, David and Song Yang. 2020. \emph{Social Network Analysis}. Sage: Quantitative
Applications in the Social Sciences (154)
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
