% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{sharp_null_double_test}
\alias{sharp_null_double_test}
\title{Asymptotic sharp null sensitivity analysis for a class of test statistics
accommodating continuous exposures and any scalar outcome.}
\usage{
sharp_null_double_test(
  Z,
  R,
  index,
  gamma = 0,
  q1 = NA,
  q2 = NA,
  X = NA,
  stratum_weights = rep(NA, nostratum),
  conservative_variance = TRUE,
  double_rank = TRUE
)
}
\arguments{
\item{Z}{A length N vector of  observed doses.}

\item{R}{A length N vector of observed outcomes.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{q1}{A transformation to apply to the doses.}

\item{q2}{A transformation to apply to the outcomes}

\item{X}{A matrix with I rows and less than I columns that contains covariate
information.}

\item{stratum_weights}{A weight vector.}

\item{conservative_variance}{Whether to use the conservative variance or not;
default is TRUE.}

\item{double_rank}{Whether to use the ranks of the transformed doses and
outcomes; default is TRUE.}
}
\value{
A list containing the deviate, one-sided p-value,
observed value of the test statistic in each matched set,
and conservative standard deviation estimate.
}
\description{
Asymptotic sharp null sensitivity analysis for a class of test statistics
accommodating continuous exposures and any scalar outcome.
}
\examples{
# Load the data
data <- lead_bmd
# conduct sharp null test at gamma = 0.
result <- sharp_null_double_test(Z = data$log_lead,
R = -data$lumbar_spine_bmd, index = data$matched_sets, gamma = 0)

}
