#' @title Shannon diversity index
#'
#' @description Computes Shannon's diversity index
#'
#' @param x Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.
#'
#' @return Shannon's diversity index (Entropy).
#'
#' @seealso \link{dec_shannon}, \link{equitability}
#'
#' @references
#' "Quantifying Diversity through Entropy Decomposition: Insights into Hominin Occupation and Carcass Processing at Qesem cave"
#'
#' @examples
#' data(Qesem_s)
#' shannon(Qesem_s$HU)
#'
#' @export
shannon <- function(x){
  x <- stats::na.omit(x)
  stopifnot(is.numeric(x))
  x <- ifelse(x==0, NA, x)
  x <- stats::na.omit(x)
  stopifnot(
    all(x >0),
    isTRUE(all.equal(x, round(x)))
  )
  p <- x/sum(x)
  return(sum(-p*log(p)))
}
