% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HurdleNegativeBinomial.R
\name{random.HurdleNegativeBinomial}
\alias{random.HurdleNegativeBinomial}
\title{Draw a random sample from a hurdle negative binomial distribution}
\usage{
\method{random}{HurdleNegativeBinomial}(x, n = 1L, drop = TRUE, ...)
}
\arguments{
\item{x}{A \code{HurdleNegativeBinomial} object created by a call to \code{\link[=HurdleNegativeBinomial]{HurdleNegativeBinomial()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
In case of a single distribution object or \code{n = 1}, either a numeric
vector of length \code{n} (if \code{drop = TRUE}, default) or a \code{matrix} with \code{n} columns
(if \code{drop = FALSE}).
}
\description{
Draw a random sample from a hurdle negative binomial distribution
}
\examples{
## set up a hurdle negative binomial distribution
X <- HurdleNegativeBinomial(mu = 2.5, theta = 1, pi = 0.75)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.25))

## cdf() and quantile() are inverses for each other
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
