% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_function.R
\name{recode_data}
\alias{recode_data}
\title{Recode values in a data frame using a lookup table}
\usage{
recode_data(data, lookup)
}
\arguments{
\item{data}{A data frame whose values you want to recode.}

\item{lookup}{A named character vector where names are original values and elements are the new values.}
}
\value{
A data frame with the same structure as \code{data}, with values recoded according to \code{lookup}.
}
\description{
This function replaces values in a data frame according to a named lookup vector.
All columns are converted to character, and any value matching a name in \code{lookup}
will be replaced by its corresponding value.
}
\examples{
df <- data.frame(
  gender = c("male", "F", "male", "female"),
  status = c("single", "Married", "oo", "M"),
  stringsAsFactors = FALSE
)

lookup <- c(
  "male" = "Male",
  "M" = "Married",
  "oo" = "Widow",
  "female" = "Female",
  "F" = "Female"
)

df_recode <- recode_data(df, lookup)
print(df_recode)

}
