% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category.R
\name{category}
\alias{category}
\title{Categorize a Numeric Variable into Custom Ranges}
\usage{
category(data, var, level, new_var = NULL, labels = NULL)
}
\arguments{
\item{data}{A data.frame or tibble containing the numeric variable.}

\item{var}{The numeric variable to categorize (unquoted).}

\item{level}{A character vector of numeric ranges, e.g., c("18-25", "26-35").}

\item{new_var}{Optional. Name of the new categorical variable. Defaults to the variable name with "_group" appended.}

\item{labels}{Optional. Custom labels for each category. Length must match \code{level}.}
}
\value{
A data.frame or tibble with a new categorical variable.
}
\description{
\code{category} creates a new categorical variable by splitting a numeric column
into specified ranges. You can provide custom labels for each range, or it will
default to the range values themselves.
}
\examples{
df <- data.frame(age = c(20, 28, 40, 55, 34, 10, 24, 55))

# Categorize without custom labels
category(df, var = age, level = c("10-25", "26-35", "36-50"))

# Categorize with custom labels
category(df, var = age, level = c("10-25", "26-35", "36-50"),
         labels = c("young", "adult", "old"))

}
