% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supported_glossary_language_pairs.R
\name{supported_glossary_language_pairs}
\alias{supported_glossary_language_pairs}
\title{List Supported Glossary Language Pairs with the DeepL API Pro}
\usage{
supported_glossary_language_pairs(auth_key)
}
\arguments{
\item{auth_key}{A string representing the authentication key for the DeepL API Pro. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\description{
\code{supported_glossary_language_pairs} lists all language pairs supported for glossary creation 
    in the DeepL API Pro.
}
\details{
To use this function, you must obtain an authentication key by registering for a DeepL API Pro account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Pro}.
}
\examples{
\dontrun{
supported_glossary_language_pairs()
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/glossaries#list-supported-glossary-language-pairs}{DeepL API Documentation — Supported Glossary Language Pairs}
}
