% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-expand.R
\name{expand.tbl_lazy}
\alias{expand.tbl_lazy}
\title{Expand SQL tables to include all possible combinations of values}
\usage{
\method{expand}{tbl_lazy}(data, ..., .name_repair = "check_unique")
}
\arguments{
\item{data}{A lazy data frame backed by a database query.}

\item{...}{Specification of columns to expand. See \link[tidyr:expand]{tidyr::expand} for
more details.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item \code{"unique_quiet"}: Same as \code{"unique"}, but "quiet"
\item \code{"universal_quiet"}: Same as \code{"universal"}, but "quiet"
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[dplyr:explain]{dplyr::show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is a method for the \link[tidyr:expand]{tidyr::expand} generics. It doesn't sort the
result explicitly, so the order might be different to what \code{expand()}
returns for data frames.
}
\examples{
\dontshow{if (rlang::is_installed("tidyr", version = "1.0.0")) withAutoprint(\{ # examplesIf}
fruits <- memdb_frame(
  type   = c("apple", "orange", "apple", "orange", "orange", "orange"),
  year   = c(2010, 2010, 2012, 2010, 2010, 2012),
  size = c("XS", "S",  "M", "S", "S", "M"),
  weights = rnorm(6)
)

# All possible combinations ---------------------------------------
fruits \%>\% tidyr::expand(type)
fruits \%>\% tidyr::expand(type, size)

# Only combinations that already appear in the data ---------------
fruits \%>\% tidyr::expand(nesting(type, size))
\dontshow{\}) # examplesIf}
}
