% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Featurelists.R
\name{UpdateFeaturelist}
\alias{UpdateFeaturelist}
\title{Update a featurelist}
\usage{
UpdateFeaturelist(featurelist, listName = NULL, description = NULL)
}
\arguments{
\item{featurelist}{list. The featurelist to delete.}

\item{listName}{character. String identifying the new featurelist
to be created.}

\item{description}{character. A user-friendly description to give a featurelist.}
}
\value{
A list with the following four elements describing
the featurelist created:
\describe{
  \item{featurelistId}{Character string giving the unique
  alphanumeric identifier for the new featurelist.}
  \item{projectId}{Character string giving the projectId
  identifying the project to which the featurelist was added.}
  \item{features}{Character vector with the names of the
  variables included in the new featurelist.}
  \item{name}{Character string giving the name of the new
  featurelist.}
}
}
\description{
Updates a featurelist to change the name or description.
}
